

<?php $__env->startSection('content'); ?>

<style>
    .win-card {
        background: #fff;
        padding: 25px;
        border-radius: 10px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        max-width: 1400px;
        margin: auto;
    }

    .summary-box {
        background: #ffe4e8;
        padding: 15px;
        border-left: 5px solid #d8134b;
        border-radius: 6px;
        margin-bottom: 20px;
    }

    .summary-box h5 {
        margin: 0;
        font-size: 17px;
        font-weight: 700;
    }

    .supplier-header {
        background: #dbe8ff;
        padding: 10px;
        border-left: 5px solid #0d6efd;
        margin-top: 20px;
        border-radius: 6px;
    }

    .ledger-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    .ledger-table th,
    .ledger-table td {
        border: 1px solid #0d6efd;
        padding: 8px;
        font-size: 15px;
        text-align: center;
    }

    .ledger-table th {
        background: #e5f0ff;
        font-weight: bold;
        color: #d8134bff;
        font-size: 16px;
    }

    #searchInput {
        width: 300px;
        padding: 8px 12px;
        border: 2px solid #0d6efd;
        border-radius: 6px;
        font-size: 16px;
        margin-bottom: 15px;
    }
</style>

<div class="container mt-4">
    <div class="win-card">
        <h3><i class="fa fa-book text-primary"></i> Purchase Ledger</h3>

        <input type="text" id="searchInput" placeholder="Search supplier name / contact...">

        <!-- OVERALL SUMMARY -->
        <div id="summaryBox"></div>

        <div id="ledgerResults"></div>
    </div>
</div>

<script>
loadLedger();

function loadLedger(search = "") {

    fetch(`<?php echo e(route('user.reports.purchaseledger.search')); ?>?search=${search}`)
        .then(res => res.json())
        .then(res => {
            // -------------------------------
            // TOP SUMMARY (OVERALL TOTALS)
            // -------------------------------
            document.getElementById("summaryBox").innerHTML = `
                <div class="summary-box">
                    <h5>
                        <span style="color:#0d6efd;">Total Purchase: </span> ₹${res.summary.total}
                        &nbsp;&nbsp;&nbsp;
                        <span style="color:#198754;">Paid: </span> ₹${res.summary.paid}
                        &nbsp;&nbsp;&nbsp;
                        <span style="color:#d8134b;">Balance: </span> ₹${res.summary.balance}
                    </h5>
                </div>
            `;

            // ---------------------------------
            // SUPPLIER WISE LEDGER
            // ---------------------------------
            const div = document.getElementById("ledgerResults");
            div.innerHTML = "";

            if (!res.data.length) {
                div.innerHTML = `<div class="text-center text-muted p-4">No supplier found</div>`;
                return;
            }

            let html = "";

            res.data.forEach(s => {

                html += `
                <div class="supplier-header">
                    <h5>${s.supplier} <span class="text-secondary">(${s.contact})</span></h5>
                    <p>
                        <strong>Total:</strong> ₹${s.total} &nbsp;&nbsp;
                        <strong>Paid:</strong> ₹${s.paid} &nbsp;&nbsp;
                        <strong>Balance:</strong> ₹${s.balance}
                    </p>
                </div>

                <table class="ledger-table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Bill No</th>
                            <th>Total Amount</th>
                            <th>Paid</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                `;

                s.records.forEach(r => {
                    html += `
                    <tr>
                        <td>${r.date}</td>
                        <td>${r.bill_no}</td>
                        <td>₹ ${r.amount}</td>
                        <td>₹ ${r.paid}</td>
                        <td>₹ ${r.balance}</td>
                    </tr>
                    `;
                });

                html += `</tbody></table>`;
            });

            div.innerHTML = html;
        });
}

document.getElementById("searchInput").addEventListener("keyup", function() {
    loadLedger(this.value);
});
</script>
<script>
document.addEventListener("keydown", function(e) {

    // If user is typing inside input, textarea — ignore backspace
    const active = document.activeElement;
    const typingTags = ["INPUT", "TEXTAREA"];

    if (typingTags.includes(active.tagName)) return;

    // Backspace = go back
    if (e.key === "Backspace") {
        e.preventDefault();
        window.location.href = "<?php echo e(route('user.reports.index')); ?>";
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\mandi\resources\views/user/reports/purchaseLedger.blade.php ENDPATH**/ ?>