

<?php $__env->startSection('content'); ?>

<style>

body {
    background: #f2f6fc;
    margin: -20;

    overflow: hidden; /* NO SCROLL */
}

/* FULL PAGE CARD CONTAINER */
.full-card {
    width: 100%;
    height: 100vh;
    padding: 30px;
    box-sizing: border-box;
    display: flex;
    justify-content: center;
    align-items: flex-start;
}

/* LARGE, PREMIUM CARD */
.profile-card {
    width: 100%;
    max-width: 1200px;   /* FULL WIDTH */
    background: #ffffff;
    border-radius: 24px;
    padding: 35px ;
    box-shadow: 0 12px 30px rgba(0,0,0,0.08);
    height: calc(100vh - 60px); /* FIT WITHOUT SCROLL */

}

/* TITLE */
.title {
    font-size: 28px;
    font-weight: 700;
    color: #222;
    margin-bottom: 20px;
}

/* Profile Photo */
.profile-img {
    width: 150px;
    height: 150px;
    border-radius: 16px;
    object-fit: cover;
    border: 3px solid #e1e1e1;
}

/* Info boxes */
.info-box {
    background: #f9f9f9;
    padding: 15px;
    border-radius: 12px;
    border: 1px solid #e7e7e7;
    margin-bottom: 10px;
    font-size: 15px;
    color: #333;
}

/* Input styles */
input, textarea {
    background: #fff !important;
    border: 1px solid #d1d1d1 !important;
    padding: 10px;
    border-radius: 10px;
    width: 100%;
    color: #000 !important;
}

/* Buttons */
.btn-main {
    background: #0078ff;
    color: white;
    padding: 12px 35px;
    font-size: 17px;
    border-radius: 12px;
    border: none;
    transition: 0.2s;
}

.btn-main:hover {
    background: #005fcc;
}

</style>



<div class="full-card">

    <div class="profile-card">

     

         <div class="d-flex mt-4" >
            <button id="editBtn" class="btn-main ms-auto">Edit</button>
        </div>


        <!-- VIEW MODE -->
      <div id="viewMode">

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($profile): ?>

    <div class="d-flex align-items-center mb-4 ">
<img src="<?php echo e(asset('storage/shop_logos/'.$profile->shop_logo)); ?>" class="profile-img">

        <h4 class="fw-bold"><?php echo e($profile->shop_name); ?></h4>
    </div>

    <!-- 2 COLUMN GRID -->
    <div class="row" style="row-gap: 15px;">

        <div class="col-md-6">
            <div class="info-box"><b>Owner:</b> <?php echo e($profile->owner_name); ?></div>
        </div>

        <div class="col-md-6">
            <div class="info-box"><b>Phone:</b> <?php echo e($profile->phone); ?></div>
        </div>

        <div class="col-md-6">
            <div class="info-box"><b>Email:</b> <?php echo e($profile->email); ?></div>
        </div>

        <div class="col-md-6">
            <div class="info-box"><b>Pincode:</b> <?php echo e($profile->pincode); ?></div>
        </div>

        <div class="col-md-6">
            <div class="info-box"><b>City:</b> <?php echo e($profile->city); ?></div>
        </div>

        <div class="col-md-6">
            <div class="info-box"><b>State:</b> <?php echo e($profile->state); ?></div>
        </div>

        <div class="col-md-12">
            <div class="info-box"><b>Address:</b> <?php echo e($profile->address); ?></div>
        </div>

    </div>

    <?php else: ?>
        <p>No profile found. Please fill details.</p>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

</div>




        <!-- EDIT MODE -->
        <form id="editMode" style="display:none;" enctype="multipart/form-data" action="<?php echo e(route('user.account.profile.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <input class="mb-3" name="shop_name" placeholder="Shop Name" value="<?php echo e($profile->shop_name ?? ''); ?>">
            <input class="mb-3" name="owner_name" placeholder="Owner Name" value="<?php echo e($profile->owner_name ?? ''); ?>">
            <input class="mb-3" name="phone" placeholder="Phone" value="<?php echo e($profile->phone ?? ''); ?>">
            <input class="mb-3" name="email" placeholder="Email" value="<?php echo e($profile->email ?? ''); ?>">
            <input type="file" name="shop_logo" class="mb-3">

            <textarea name="address" class="mb-3" placeholder="Address"><?php echo e($profile->address ?? ''); ?></textarea>

            <div class="row">
                <div class="col-md-4">
                    <input class="mb-3" name="city" placeholder="City" value="<?php echo e($profile->city ?? ''); ?>">
                </div>
                <div class="col-md-4">
                    <input class="mb-3" name="state" placeholder="State" value="<?php echo e($profile->state ?? ''); ?>">
                </div>
                
                <div class="col-md-4">
                    <input class="mb-3" name="pincode" placeholder="Pincode" value="<?php echo e($profile->pincode ?? ''); ?>">
                </div>
            </div>
        </form>



        <!-- SINGLE BUTTON -->
       
    </div>

</div>



<script>
let editBtn = document.getElementById("editBtn");
let viewMode = document.getElementById("viewMode");
let editMode = document.getElementById("editMode");
let editing = false;

editBtn.addEventListener("click", function () {

    if (!editing) {
        viewMode.style.display = "none";
        editMode.style.display = "block";
        editBtn.innerText = "Update";
        editing = true;
    } else {
        let formData = new FormData(editMode);

      fetch("<?php echo e(route('user.account.profile.update')); ?>", {
    method: "POST",
    body: formData
})
.then(r => r.json())
.then(d => {
    if (d.success) location.reload();
});
    }
});
</script>
<script>
document.addEventListener("input", function (e) {
    if (e.target.tagName === "INPUT" || e.target.tagName === "TEXTAREA") {
        e.target.value = e.target.value.toUpperCase();
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\mandi\resources\views/account/profile.blade.php ENDPATH**/ ?>