

<?php $__env->startSection('content'); ?>

<style>
 
.admin-wrapper {
    font-family: "Poppins", sans-serif;


    min-height: calc(100vh - 70px);
    padding: 35px;
    margin: 0;
}
/* Smooth auto-changing background */
/* Adds smooth 20s gradient morphing effect */
.animated-bg {
    background: linear-gradient(135deg, #082e50ff, #00f2fe);
    background-size: 300% 300%;
    animation: smoothGradient 20s ease infinite;
}

/* Smoothly morph between gradients (no flipping) */
@keyframes smoothGradient {
    0% {
        background-position: 0% 50%;
    }
    50% {
        background-position: 100% 50%;
    }
    100% {
        background-position: 0% 50%;
    }
}


.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    margin-bottom: 25px;
}

.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 28px;
  margin-left: 15px;
}

.switch input { opacity: 0; width: 0; height: 0; }

.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
}

.slider:before {
  position: absolute;
  content: "";
  height: 22px;
  width: 22px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  transition: 0.4s;
  border-radius: 50%;
}

input:checked + .slider { background-color: #ff5252; }
input:checked + .slider:before { transform: translateX(32px); }

.card-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 22px;
}

.card {
    background: rgba(255,255,255,0.18);
    backdrop-filter: blur(14px);
    padding: 25px;
    border-radius: 18px;
    color: #fff;
    border: 1px solid rgba(255,255,255,0.25);
    box-shadow: 0 8px 30px rgba(0,0,0,0.25);
    transition: 0.3s;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 35px rgba(0,0,0,0.35);
}

.card i {
    font-size: 45px;
    margin-bottom: 15px;
}
</style>

<div class="admin-wrapper animated-bg">


    <!-- TOP BAR -->
    <div class="topbar">
        <h2 style="margin:0;"><?php echo e(t('Admin Dashboard')); ?></h2>

        <div style="display:flex; align-items:center;"><?php echo e(__('messages.language')); ?>


            <label class="switch">
                <input type="checkbox" id="langToggle" 
                       <?php echo e(session('locale') == 'ta' ? 'checked' : ''); ?> 
                       <?php echo e(App::getLocale() == 'ta' ? 'checked' : ''); ?>>
                <span class="slider"></span>
                <?php echo e(App::getLocale() == 'ta' ? 'English' : 'தமிழ்'); ?>

            </label>

        </div>
    </div>

    <!-- DASHBOARD CARDS -->
    <div class="card-container">

       <div class="card">
    <h3><?php echo e(__('messages.total_Suppliers')); ?></h3>

    <p class="fs-4"><?php echo e($supplierCount); ?> <?php echo e(__('messages.Suppliers')); ?></p>
</div>


        <div class="card">
            <h3><?php echo e(__('messages.total_Customers')); ?></h3>
            <p class="fs-4"><?php echo e($customerCount); ?> <?php echo e(__('messages.Customers')); ?></p>
        </div>

        <div class="card">
            <h3><?php echo e(__('messages.today Sales')); ?></h3>
            <!-- <p class="fs-4"><?php echo e($todaysales); ?></p> -->
        </div>

        <div class="card">
            <h3><?php echo e(__('messages.today Purchase')); ?></h3>
            <!-- <p class="fs-4"><?php echo e($todaypurchase); ?></p> -->
        </div>

    </div>

    <br><br>

    <!-- NEW MENU CARD BUTTONS (ADDED HERE) -->
    <div class="card-container">

        <a href="<?php echo e(route('user.lines.create')); ?>" class="card text-decoration-none">
            <i class="fa fa-road"></i>
            <h3>Lines</h3>
        </a>

        <a href="<?php echo e(route('user.members.create')); ?>" class="card text-decoration-none">
            <i class="fa fa-users"></i>
            <h3>Members</h3>
        </a>

        <a href="<?php echo e(route('user.products.create')); ?>" class="card text-decoration-none">
            <i class="fa fa-box"></i>
            <h3>Products</h3>
        </a>

        <a href="<?php echo e(route('user.purchase.create')); ?>" class="card text-decoration-none">
            <i class="fa fa-shopping-cart"></i>
            <h3>Purchase</h3>
        </a>

        <a href="<?php echo e(route('user.sales.create')); ?>" class="card text-decoration-none">
            <i class="fa fa-chart-line"></i>
            <h3>Sales</h3>
        </a>

        <a href="<?php echo e(route('user.reports.index')); ?>" class="card text-decoration-none">
            <i class="fa fa-file-alt"></i>
            <h3>Reports</h3>
        </a>
      <a href="<?php echo e(route('user.expenses.dashboard')); ?>" class="card text-decoration-none">
    <i class="fa fa-money-bill-wave"></i>
    <h3>Payments</h3>
</a>


    </div>

</div>

<script>
document.getElementById('langToggle').addEventListener('change', function() {
    let locale = this.checked ? 'ta' : 'en';
    window.location.href = '/lang/' + locale;
});
</script>

<script>
$('#langToggle').change(function () {
    let locale = $(this).is(':checked') ? 'ta' : 'en';
    window.location.href = "<?php echo e(url('lang')); ?>/" + locale;
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\mandi\resources\views/user/dashboard.blade.php ENDPATH**/ ?>