

<?php $__env->startSection('content'); ?>

<style>
    /* Bigger Windows-style Card */
    .bill-box {
        max-width: 1100px;
        margin: auto;
        padding: 40px;
        border: 1px solid #c6c6c6;
        border-radius: 14px;
        background: #ffffff;
        box-shadow: 0 6px 14px rgba(0,0,0,0.10);
    }

    .title {
        font-size: 32px;
        font-weight: 700;
        color: #202124;
        margin-bottom: 10px;
    }

    .info-box {
        font-size: 18px;
        line-height: 1.6;
    }

    .info-box b {
        width: 180px;
        display: inline-block;
        color: #333;
    }

    /* Table Style */
    table {
        width: 100%;
        margin-top: 20px;
        border-collapse: collapse;
        background: #fbfbfb;
        font-size: 17px;
    }

    table thead {
        background: #e1e9f5;
        font-weight: bold;
        border-bottom: 3px solid #b5c6e0;
    }

    table thead th {
        padding: 14px;
        color: #1d3b6b;
        border-right: 1px solid #c9d5e3;
        font-size: 17px;
    }

    table tbody td {
        padding: 14px;
        font-size: 17px;
        border-bottom: 1px solid #e0e0e0;
        border-right: 1px solid #e0e0e0;
    }

    table tbody tr:hover {
        background: #f1f6ff;
    }

    .total-box {
        text-align: right;
        font-size: 28px;
        margin-top: 20px;
        font-weight: bold;
        color: #111;
    }

    .btn {
        font-size: 16px !important;
        padding: 8px 18px !important;
    }
</style>


<div class="bill-box mt-4">

    
    <div class="float-end">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mode === 'purchase'): ?>
            <a href="<?php echo e(route('user.reports.purchases')); ?>" class="btn btn-sm btn-secondary">Back to Reports</a>
        <?php else: ?>
            <a href="<?php echo e(route('user.reports.sales')); ?>" class="btn btn-sm btn-secondary">Back to Reports</a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    
    <div class="title">
        <?php echo e($mode === 'purchase' ? 'Purchase Details' : 'Sales Details'); ?>

    </div>
    <hr>

    
    <div class="info-box">
        <b>Date:</b> <?php echo e($bill->date); ?> <br>
        <b>Line:</b> <?php echo e($bill->line_name); ?> <br>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mode === 'purchase'): ?>
            <b>Supplier:</b> <?php echo e($bill->supplier_name); ?> <br>
            <b>Phone:</b> <?php echo e($bill->supplier_contact); ?> <br>
            <b>Address:</b> <?php echo e($bill->supplier_address); ?> <br>
        <?php else: ?>
            <b>Customer:</b> <?php echo e($bill->customer_name); ?> <br>
            <b>Phone:</b> <?php echo e($bill->customer_contact); ?> <br>
            <b>Address:</b> <?php echo e($bill->customer_address); ?> <br>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <hr>

    <h5>Item Details</h5>

    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Qty</th>
                <th>Rate</th>
                <th>Amount</th>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mode === 'purchase'): ?>
                    <th>Sup Amount</th>
                    <th>Com Amount</th>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <th>Date</th>
            </tr>
        </thead>

        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($i->product_name); ?></td>
                <td><?php echo e($i->quantity); ?></td>
                <td>₹ <?php echo e($i->rate); ?></td>
                <td>₹ <?php echo e($i->amount); ?></td>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mode === 'purchase'): ?>
                    <td>₹ <?php echo e($i->sup_amount); ?></td>
                    <td>₹ <?php echo e($i->com_amount); ?></td>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <td><?php echo e($bill->date); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    <div class="total-box">
        Total: ₹ <?php echo e($bill->total_amount); ?>

    </div>

</div>

<?php $__env->stopSection(); ?>



<script>
   const backUrl = "<?php echo e($mode === 'purchase'  ? route('user.reports.purchases') : route('user.reports.sales')); ?>";


    document.addEventListener("keydown", function(e) {

        const active = document.activeElement;
        const typingTags = ["INPUT", "TEXTAREA"];

        if (typingTags.includes(active.tagName)) return;

        if (e.key === "Backspace") {
            e.preventDefault();
            window.location.href = backUrl;
        }
    });
</script>


<?php echo $__env->make('layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\mandi\resources\views/user/reports/show.blade.php ENDPATH**/ ?>