<style>
/* 🌟 Common Header Styling */

/* Remove dropdown arrow */
.navbar-nav .dropdown-toggle::after {
    display: none !important;
}

/* Logo */
.navbar-brand img {
    height: 60px;
    width: auto;
    border-radius: 6px;
    transition: transform 0.3s ease;
}
.navbar-brand img:hover {
    transform: scale(1.05);
}

/* Profile icon */
.nav-link i {
    font-size: 1.8rem;
    color: #555;
}
.nav-link span {
    color: #555;
    font-weight: 500;
}

/* Dropdown menu */
.dropdown-menu {
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    border: none;
    padding: 8px 0;
}

/* Logout hover */
.dropdown-item.text-danger:hover {
    background-color: #fee2e2;
}

/* Mobile adjustments */
@media (max-width: 768px) {
    .navbar {
        padding: 0.3rem 0.8rem;
    }

    /* Logo smaller */
    .navbar-brand img {
        height: 45px;
    }

    /* Hide username to save space */
    .nav-link span {
        display: none;
    }

    /* Profile icon larger */
    .nav-link i {
        font-size: 2rem;
    }

    .dropdown-menu {
        right: 0;
        left: auto;
        min-width: 160px;
    }
}

.navbar {
  position: relative;
  z-index: 1000;
}

.navbar .dropdown-menu {
  position: absolute !important;
  top: 100% !important;
  right: 0;
  left: auto;
  margin-top: 0;
  z-index: 2000;
}

/* ===============================
   ⭐ Center Animated Shop Name ⭐
   =============================== */

.navbar-center-title {
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -50%);
    font-size: 26px;
    font-weight: 700;
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(90deg, #ff0080, #7928ca, #2afadf);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    animation: glowText 3s infinite linear;
    letter-spacing: 1px;
    white-space: nowrap;
}

@keyframes glowText {
    0%   { text-shadow: 0 0 5px rgba(255,255,255,0.4); }
    50%  { text-shadow: 0 0 20px rgba(255,255,255,0.9); }
    100% { text-shadow: 0 0 5px rgba(255,255,255,0.4); }
}




.nine h1 {
  text-align: center;
  font-size: 50px; /* Desktop size */
  text-transform: uppercase;
  color: #222;
  letter-spacing: 1px;
  font-family: "Playfair Display", serif;
  font-weight: 400;
  margin: 0;
}

.nine h1 span {
  margin-top: 5px;
  font-size: 15px;
  color: #444;
  word-spacing: 1px;
  font-weight: 500;
  letter-spacing: 2px;
  text-transform: uppercase;
  font-family: "Raleway", sans-serif;
  
  display: grid;
  grid-template-columns: 1fr max-content 1fr;
  grid-template-rows: 27px 0;
  grid-gap: 20px;
  align-items: center;
}

.nine h1 span:after,
.nine h1 span:before {
  content: " ";
  display: block;
  border-bottom: 1px solid #ccc;
  border-top: 1px solid #ccc;
  height: 5px;
  background-color: #f8f8f8;
}

/* ===== Responsive for Mobile ===== */
@media (max-width: 768px) {
  .nine h1 {
    font-size: 24px;  /* smaller font */
    line-height: 1.2;
  }

  .nine h1 span {
    font-size: 12px;
    grid-gap: 10px;  /* reduce space between lines */
    grid-template-columns: 1fr auto 1fr; /* keep lines smaller */
  }

  .nine h1 span:after,
  .nine h1 span:before {
    height: 3px; /* thinner decorative lines */
  }
}


</style>



<nav class="navbar navbar-light bg-white shadow-sm px-3">

    <!-- Sidebar Toggle -->
    <button class="btn btn-outline-secondary me-3" onclick="toggleSidebar()">
        <i class="fa fa-bars"></i>
    </button>

    <!-- ⭐ CENTERED SHOP NAME -->
    <!-- <div class="navbar-center-title">
        <?php echo e(t(session('shop_name') ?? 'My Shop')); ?>

    </div> -->
<div class="nine sm-2">
  <h1><?php echo e(t(session('shopname') ?? 'My Shop')); ?></h1>
</div>
    <div class="ms-auto d-flex align-items-center">

        <!-- Theme Button -->
    <?php
    $role = session('login.role_id') ?? null;

    if ($role == 1) {
        $url = route('admin.dashboard');
    } elseif ($role == 2) {
        $url = route('user.dashboard');
    } else {
        $url = route('login');
    }
?>

<a href="<?php echo e($url); ?>" class="btn btn-sm btn-primary me-3" id="toggleThemeBtn">
    <i class="fa fa-moon"></i>
</a>



        <!-- Profile Dropdown -->
        <ul class="navbar-nav ms-2">
            <li class="nav-item dropdown">

<a class="nav-link d-flex align-items-center" href="#" id="userDropdown"
   data-bs-toggle="dropdown" aria-expanded="false">


    <span class="fw-semibold"
          style="font-size: 17px;
                 color: #2d2d2d;
                 background: #f3f6fb;
                 padding: 6px 14px;
                 border-radius: 12px;
                 box-shadow: 0 2px 6px rgba(0,0,0,0.08);
                 margin-right: 12px;">
        <?php echo e(session('username') ?? 'Guest'); ?>

    </span>
    
  <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('shop_logo')): ?>
    <img src="<?php echo e(asset('storage/shop_logos/' . session('shop_logo'))); ?>"
         class="rounded-circle"
         style="width:60px;height:60px;object-fit:cover;">
<?php else: ?>
    <div class="rounded-circle bg-primary text-white d-flex justify-content-center align-items-center"
         style="width:38px;height:38px;font-size:20px;">
        <i class="bi bi-person"></i>
    </div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>





</a>

                <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="userDropdown">

                    <li>
                       <a class="dropdown-item" href="<?php echo e(route('account.profile')); ?>">
    <i class="bi bi-person"></i> Profile
</a>
                    </li>

                    <li>
                      <a class="dropdown-item" href="<?php echo e(route('account.settings')); ?>">
    <i class="bi bi-gear"></i> Settings
</a>
                    </li>

                    <li><hr class="dropdown-divider"></li>

                    <li>
                        <a class="dropdown-item text-danger" href="#"
                           onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                    </li>

                </ul>
            </li>
        </ul>

    </div>
</nav>
<?php /**PATH C:\laragon\www\mandi\resources\views/layout/header.blade.php ENDPATH**/ ?>