<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Middleware\CheckSession;
use App\Http\Middleware\PreventBackHistory;
use App\Http\Middleware\CheckRole;
use App\Http\Middleware\SetLocale;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Admin\AddUserController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\TransliterateController;
use App\Http\Controllers\User\LineController;
use App\Http\Controllers\User\MemberController;
use App\Http\Controllers\User\ProductController;
use App\Http\Controllers\User\PurchaseController;
use App\Http\Controllers\User\SaleController;
use App\Http\Controllers\User\ReportController;
use App\Http\Controllers\User\ExpenseController;
use App\Http\Controllers\User\shop_profile;
use App\Http\Controllers\User\PurchasePaymentController;
use App\Http\Controllers\User\SalesPaymentController;
/*
|--------------------------------------------------------------------------
| LANGUAGE SWITCH
|--------------------------------------------------------------------------
*/
Route::get('/lang/{locale}', function ($locale) {
    if (!in_array($locale, ['en', 'ta'])) {
        $locale = 'en';
    }
    session(['locale' => $locale]);
    return redirect()->back();
})->name('lang.switch');


/*
|--------------------------------------------------------------------------
| LOGIN & ACCOUNT ROUTES
|--------------------------------------------------------------------------
*/
Route::middleware(['web'])->group(function () {

    Route::middleware([PreventBackHistory::class])->group(function () {

        // LOGIN
        Route::get('/', [LoginController::class, 'showLoginForm'])->name('login');
        Route::post('/login', [LoginController::class, 'login'])->name('login.submit');

        // ACCOUNT
        Route::get('/profile', [AccountController::class, 'profile'])->name('account.profile');
        Route::post('/profile/update', [AccountController::class, 'updateProfile'])->name('account.profile.update');

        Route::get('/settings', [AccountController::class, 'settings'])->name('account.settings');
        Route::post('/password/update', [AccountController::class, 'updatePassword'])->name('account.password.update');
        Route::post('/theme/update', [AccountController::class, 'updateTheme'])->name('account.theme.update');
    });

    // TRANSLITERATION (AJAX)
    Route::post('/transliterate-tamil', [TransliterateController::class, 'transliterateTamil'])
        ->name('transliterate.tamil');

    // LOGOUT
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');


    /*
    |--------------------------------------------------------------------------
    | ADMIN ROUTES
    |--------------------------------------------------------------------------
    */
    Route::middleware([
        SetLocale::class,
        CheckSession::class,
        PreventBackHistory::class,
        CheckRole::class . ':Admin'
    ])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {

        Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
        // User Manage
        Route::get('/create', [AddUserController::class, 'create'])->name('create');
        Route::post('/users/store', [AddUserController::class, 'store'])->name('store');
        Route::get('/user/edit/{id}', [AddUserController::class, 'edit'])->name('edit');
        Route::post('/user/update/{id}', [AddUserController::class, 'update'])->name('update');
        Route::get('/user/delete/{id}', [AddUserController::class, 'destroy'])->name('destroy');
    });

/*
|--------------------------------------------------------------------------
| USER ROUTES
|--------------------------------------------------------------------------
*/
Route::middleware([
    SetLocale::class,
    CheckSession::class,
    PreventBackHistory::class,
    CheckRole::class . ':User'
])
->prefix('user')
->name('user.')
->group(function () {

    // Dashboard
    Route::get('/dashboard', [UserController::class, 'dashboard'])->name('dashboard');
    // Profile + Settings
    Route::get('/profile', fn() => view('user.profile'))->name('profile');
    Route::get('/settings', fn() => view('user.settings'))->name('settings');
    /*
    |--------------------------------------------------------------------------
    | CRUD Routes
    |--------------------------------------------------------------------------
    */

    // line

    Route::resource('lines', LineController::class);
     Route::get('lines', [LineController::class, 'index'])->name('lines.index');

    // Create/store via AJAX or normal post
    Route::post('lines', [LineController::class, 'store'])->name('lines.store');

    // Update (patch) - route model binding will use line_id
Route::patch('lines/{id}', [LineController::class, 'update'])->name('lines.update');
Route::delete('lines/{id}', [LineController::class, 'destroy'])->name('lines.destroy');


    // Restore soft-deleted by id
    Route::post('lines/{id}/restore', [LineController::class, 'restore'])->name('lines.restore');

    // ------------------------------------------------------------------------------------------------

    // Create page
    Route::get('/members/create', [MemberController::class, 'create'])->name('members.create');

    // Store
    Route::post('/members', [MemberController::class, 'store'])->name('members.store');

    // Edit
    Route::get('/members/{member}/edit', [MemberController::class, 'edit'])->name('members.edit');

    // Update
Route::put('/members/{member}', [MemberController::class, 'update'])->name('members.update');


    // Delete
    Route::delete('/members/{member}', [MemberController::class, 'destroy'])->name('members.destroy');

    // Restore
    Route::post('/members/{id}/restore', [MemberController::class, 'restore'])->name('members.restore');

    
    // ------------------------------------------------------------------------------------------------
  
    Route::resource('products', ProductController::class);
    /*
    |--------------------------------------------------------------------------
    | SALES ROUTES
    |--------------------------------------------------------------------------
    */
    Route::resource('sales', SaleController::class)->except(['edit', 'update', 'show']);
    Route::get('/sales/create', [SaleController::class, 'create'])->name('sales.create');
    Route::post('/sales/save', [SaleController::class, 'save'])->name('sales.save');
    Route::get('/search/saleslines', [SaleController::class, 'searchLines'])->name('search.saleslines');
    Route::get('/search/customers', [SaleController::class, 'searchCustomers'])->name('search.customer');
    Route::get('/search/salesproducts', [SaleController::class, 'searchProducts'])    ->name('search.sales.products');
    Route::get('/sales/todayData', [SaleController::class, 'todayData'])->name('sales.todaysales');
         Route::delete(
        '/sales/{sale}/soft-delete',
        [SaleController::class, 'softDelete']
    )->name('sales.softDelete');
    /*
    |--------------------------------------------------------------------------
    | PURCHASE ROUTES
    |--------------------------------------------------------------------------
    */
    Route::put('/purchase/{purchase}', [PurchaseController::class, 'update'])->name('purchase.update');
    Route::resource('purchase', PurchaseController::class)->only(['create']);
    Route::get('/purchase/create', [PurchaseController::class, 'create'])->name('purchase.create');
    Route::post('/purchase/save', [PurchaseController::class, 'save'])->name('purchase.save');
    Route::get('/search/purchaselines', [PurchaseController::class, 'searchLines'])->name('search.lines');
    Route::get('/search/suppliers', [PurchaseController::class, 'searchSuppliers'])->name('search.suppliers');
    Route::get('/search/purchaseproducts', [PurchaseController::class, 'searchProducts'])->name('search.purchase.products');
    Route::get('/purchase/today-data', [PurchaseController::class, 'todayData'])->name('purchase.todayData');

    Route::delete('/purchase/{purchase}/soft-delete', [PurchaseController::class, 'softDelete'])
    ->name('purchase.softDelete');

    /*
    |--------------------------------------------------------------------------
    | REPORTS ROUTES (Corrected & Grouped)
    |--------------------------------------------------------------------------
    */
    Route::prefix('reports')->name('reports.')->group(function () {
    Route::get('/', [ReportController::class, 'index'])->name('index');
    Route::get('/purchases', [ReportController::class, 'purchaseReport'])->name('purchases');
    Route::get('/sales', [ReportController::class, 'salesReport'])->name('sales');
    // DAILY SALES
    Route::get('/dailysales', [ReportController::class, 'dailysalesReport'])->name('dailysales');
    Route::get('/dailypurchase', [ReportController::class, 'dailypurchaseReport'])->name('dailypurchase');
    Route::get('/dailysales/search', [ReportController::class, 'dailySalesSearch'])->name('dailysales.search');
    Route::get('/stock', [ReportController::class, 'stockReport'])->name('stock');
    // SEARCH
    Route::get('/purchases/search', [ReportController::class, 'searchPurchase'])->name('purchases.searchPurchase');
    Route::get('/sales/searchSales', [ReportController::class, 'searchSales'])->name('sales.searchSales');
    // SHOW BILL
    Route::get('/purchase/{id}', [ReportController::class, 'showPurchase'])->name('purchase.show');
    Route::get('/sales/{id}', [ReportController::class, 'showSales'])->name('sales.show');
    Route::get('/dailypurchase/search', [ReportController::class, 'todayPurchases'])->name('dailypurchase.search');
    Route::get('/reports/purchase-ledger', [ReportController::class, 'purchaseLedger'])->name('purchaseledger');
    Route::get('/reports/purchaseledger/search', [ReportController::class, 'purchaseLedgerSearch'])->name('purchaseledger.search');
    Route::get('/reports/sales-ledger', [ReportController::class, 'salesLedger'])->name('ledgersales');
    Route::get('/reports/sales-ledger/search', [ReportController::class, 'salesLedgerSearch'])->name('salesledger.search');
});
// Expense routes
 Route::get('/expenses', [\App\Http\Controllers\User\ExpenseController::class, 'index'])->name('expenses.index');
    Route::post('/expenses/store', [\App\Http\Controllers\User\ExpenseController::class, 'store'])->name('expenses.store');
    Route::get('/expenses/today', [\App\Http\Controllers\User\ExpenseController::class, 'todayTotal'])->name('expenses.today');
    Route::get('/expenses/search', [\App\Http\Controllers\User\ExpenseController::class, 'search'])->name('expenses.search');
    Route::post('/expenses/categories', [\App\Http\Controllers\User\ExpenseController::class, 'createCategory'])->name('expenses.category.create');
    Route::get('/expenses/dashboard', [ExpenseController::class, 'dashboard'])->name('expenses.dashboard');
    Route::get('/task/dashboard', [ExpenseController::class, 'managedashboard'])->name('manage.managedashboard');
    Route::get('/account/profile', [shop_profile::class, 'index'])->name('account.profile');
    Route::post('/account/profile/update', [shop_profile::class, 'update'])->name('account.profile.update');
    Route::post('/account/shop-profile/save', [shop_profile::class, 'saveShopProfile'])->name('shop.profile.save');
    Route::get('/account/profile', [shop_profile::class, 'index'])->name('account.profile');
    Route::get('/account/profile/fetch', [shop_profile::class, 'fetch'])->name('account.profile.fetch');
    // Route::post('/account/profile/save', [shop_profile::class, 'save'])->name('account.profile.save');

// ----------------------------------------------------------------------------------------------------------
    Route::get('purchase-payment', [PurchasePaymentController::class, 'index'])
    ->name('purchase.payment');

Route::get('sales-payment', [SalesPaymentController::class, 'index'])
    ->name('sales.payment');




Route::get('/user/purchase-payments', [PurchasePaymentController::class, 'index'])
    ->name('purchase_payments.index');
Route::get('/purchase_payments/lines/search', [PurchasePaymentController::class, 'search'])
    ->name('purchase_payments.lines.search');



Route::get('/user/purchase-payments/search/person', [PurchasePaymentController::class, 'searchPerson'])
    ->name('purchase_payments.searchperson');

Route::post('/purchase-payments/getbalance', [PurchasePaymentController::class, 'getSupplierBalance'])->name('purchase_payments.getbalance');
Route::post('/purchase-payments/store', [PurchasePaymentController::class, 'store'])->name('purchase_payments.store');
// ------------------------------------------------------------------------------------------------------------------
Route::get('sales-payment', [SalesPaymentController::class, 'index'])
    ->name('sales.payment');
});

Route::get('/sales-payments', 
        [SalesPaymentController::class, 'index']
    )->name('user.sales_payments.index');

    // Line autocomplete
    Route::get('/sales-payments/lines/search', 
        [SalesPaymentController::class, 'searchLines']
    )->name('user.sales_payments.lines.search');

    // Customer autocomplete
    Route::get('/sales-payments/search-customer', 
        [SalesPaymentController::class, 'searchCustomer']
    )->name('user.sales_payments.searchcustomer');

    // Get sales balance
    Route::post('/sales-payments/get-balance', 
        [SalesPaymentController::class, 'getBalance']
    )->name('user.sales_payments.getbalance');

    // Store sales payment
    Route::post('/sales-payments/store', 
        [SalesPaymentController::class, 'store']
    )->name('user.sales_payments.store');


        });