@extends('layout.app')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
.autocomplete-active { background: #0d6efd !important; color: white !important; }
.input-focus { border: 2px solid #0d6efd !important; box-shadow: 0 0 0 0.2rem rgba(13,110,253,.25); }
.suggestions {
    position: absolute;
    z-index: 2000;
    max-height: 220px;
    overflow: auto;
    background: white;
    border: 1px solid #ddd;
    width: 100%;
    border-radius: 4px;
}
.suggestion-item { padding:8px 10px; cursor:pointer; }
.suggestion-item.active { background:#e9f2ff; }
.position-relative { position: relative; }
</style>

<div class="container-fluid">
    <h4 class="mb-3">Sales Payment Entry</h4>

    <div class="row mb-2">
        <div class="col-md-3">
            <label>Date</label>
            <input type="date" id="payment_date" class="form-control input-focus" value="{{ date('Y-m-d') }}">
        </div>

        {{-- LINE AUTOCOMPLETE --}}
        <div class="col-md-4 position-relative">
            <label>Line (type and press Enter)</label>
            <input type="text" id="lineInput" class="form-control input-focus" placeholder="Type line" autocomplete="off">
            <div id="lineSuggestions" class="suggestions d-none"></div>
        </div>

        {{-- CUSTOMER AUTOCOMPLETE --}}
        <div class="col-md-3 position-relative">
            <label>Customer</label>
            <input type="text" id="customer_search" class="form-control input-focus" placeholder="Search Customer" autocomplete="off">
            <div id="customerSuggestions" class="suggestions d-none"></div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <table class="table table-bordered">
                <tr><th>Total Sales</th><td id="total_amount">0.00</td></tr>
                <tr><th>Received Till Now</th><td id="paid_amount_total">0.00</td></tr>
                <tr><th>Balance</th><td id="balance_amount" class="fw-bold text-danger">0.00</td></tr>
            </table>
        </div>
    </div>

    <div class="row mb-2">
        <div class="col-md-6">
            <label>Description</label>
            <input type="text" id="description" class="form-control input-focus" value="Received cash from customer">
        </div>

        <div class="col-md-3">
            <label>Received Amount</label>
            <input type="number" id="paid_amount" class="form-control input-focus" placeholder="Enter amount & press Enter">
        </div>
    </div>

    {{-- Hidden Fields --}}
    <input type="hidden" id="line_id">
    <input type="hidden" id="customer_id">
    <input type="hidden" id="payment_type" value="sales">
    <input type="hidden" id="line_name">
    <input type="hidden" id="customer_name">
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(function(){

    const csrf = $('meta[name="csrf-token"]').attr('content');

    function debounce(fn, delay=300){
        let timer;
        return function(...args){
            clearTimeout(timer);
            timer = setTimeout(()=> fn.apply(this,args), delay);
        }
    }

    function setupAutocomplete(input, suggestionsDiv, url, onSelect){
        let selectedIndex = -1;

        function renderList(items){
            suggestionsDiv.empty();
            selectedIndex = -1;

            if(items.length === 0){
                suggestionsDiv.append(
                    $('<div>').addClass('suggestion-item text-muted')
                              .css({cursor:'not-allowed'})
                              .text('No data found')
                );
                suggestionsDiv.removeClass('d-none');
                return;
            }

            items.forEach((item)=>{
                suggestionsDiv.append(
                    $('<div>').addClass('suggestion-item')
                              .text(item.name)
                              .attr('data-id', item.id)
                );
            });

            suggestionsDiv.removeClass('d-none');
        }

        input.on('input', debounce(function(){
            let q = $(this).val();
            if(q.length < 1){
                suggestionsDiv.addClass('d-none');
                return;
            }

            $.get(url, { q }, renderList);
        }));

        input.on('keydown', function(e){
            const items = suggestionsDiv.children('.suggestion-item');
            if(!items.length) return;

            if(e.key === 'ArrowDown'){
                e.preventDefault();
                selectedIndex = (selectedIndex + 1) % items.length;
            }
            else if(e.key === 'ArrowUp'){
                e.preventDefault();
                selectedIndex = (selectedIndex - 1 + items.length) % items.length;
            }
            else if(e.key === 'Enter'){
                e.preventDefault();
                const sel = selectedIndex >= 0 ? items.eq(selectedIndex) : items.eq(0);
                if(!sel.data('id')) return;

                onSelect(sel.data('id'), sel.text());
                input.val(sel.text());
                suggestionsDiv.addClass('d-none');
                selectedIndex = -1;

                if(input.attr('id') === 'customer_search'){
                    fetchBalances();
                }
            }

            items.removeClass('active').eq(selectedIndex).addClass('active');
        });

        suggestionsDiv.on('click', '.suggestion-item', function(){
            if(!$(this).data('id')) return;
            onSelect($(this).data('id'), $(this).text());
            input.val($(this).text());
            suggestionsDiv.addClass('d-none');
            selectedIndex = -1;

            if(input.attr('id') === 'customer_search'){
                fetchBalances();
            }
        });

        $(document).on('click', function(e){
            if(!$(e.target).closest(input).length && !$(e.target).closest(suggestionsDiv).length){
                suggestionsDiv.addClass('d-none');
            }
        });
    }

    /** Line */
    setupAutocomplete(
        $('#lineInput'),
        $('#lineSuggestions'),
        "{{ route('user.sales_payments.lines.search') }}",
        (id,name)=>{
            $('#line_id').val(id);
            $('#line_name').val(name);
            $('#customer_search').focus();
        }
    );

    /** Customer */
    setupAutocomplete(
        $('#customer_search'),
        $('#customerSuggestions'),
        "{{ route('user.sales_payments.searchcustomer') }}",
        (id,name)=>{
            $('#customer_id').val(id);
            $('#customer_name').val(name);
            $('#description').focus();
        }
    );

    function fetchBalances(){
        if(!$('#line_id').val() || !$('#customer_id').val()) return;

        $.post("{{ route('user.sales_payments.getbalance') }}", {
            _token: csrf,
            line_id: $('#line_id').val(),
            customer_id: $('#customer_id').val(),
            payment_date: $('#payment_date').val()
        }, function(res){
            $('#total_amount').text(parseFloat(res.total).toFixed(2));
            $('#paid_amount_total').text(parseFloat(res.paid).toFixed(2));
            $('#balance_amount').text(parseFloat(res.balance).toFixed(2));
        });
    }

    $('#description').on('keydown', e=>{
        if(e.key==='Enter'){ e.preventDefault(); $('#paid_amount').focus(); }
    });

    $('#paid_amount').on('keydown', function(e){
        if(e.key==='Enter'){
            e.preventDefault();

            $.post("{{ route('user.sales_payments.store') }}", {
                _token: csrf,
                payment_date: $('#payment_date').val(),
                line_id: $('#line_id').val(),
                line_name: $('#line_name').val(),
                customer_id: $('#customer_id').val(),
                customer_name: $('#customer_name').val(),
                description: $('#description').val(),
                paid_amount: $('#paid_amount').val(),
                payment_type: 'sales'
            }, function(){
                alert('Sales payment saved successfully');
                $('input').val('');
                $('#payment_date').val("{{ date('Y-m-d') }}");
                $('#total_amount,#paid_amount_total,#balance_amount').text('0.00');
                $('#lineInput').focus();
            });
        }
    });

    $('#payment_date').on('change', fetchBalances);
});
</script>
@endsection
