@extends('layout.app')

@section('content')
<div class="container mt-4">

    <h2>Edit Sale</h2>

    <form action="{{ route('user.sales.update', $sale->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label>Customer Name</label>
            <input type="text" name="customer_name" value="{{ $sale->customer_name }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label>Total Amount</label>
            <input type="number" name="total_amount" value="{{ $sale->total_amount }}" class="form-control" required>
        </div>

        <button class="btn btn-warning">Update</button>
        <a href="{{ route('user.sales.index') }}" class="btn btn-secondary">Back</a>
    </form>

</div>
@endsection
