@extends('layout.app')

@section('content')
<div class="container mt-4">

    <h2 class="mb-3">Stock Report</h2>

    <div class="card shadow-sm">
        <div class="card-body">

            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Product</th>
                    <th>In Qty</th>
                    <th>Out Qty</th>
                    <th>Available</th>
                </tr>
                </thead>

                <tbody>
                @foreach($products as $p)

                    @php
                        $in = $p->purchaseItems->sum('qty');
                        $out = $p->saleItems->sum('qty');
                        $avail = $in - $out;
                    @endphp

                    <tr>
                        <td>{{ $p->id }}</td>
                        <td>{{ $p->name }}</td>
                        <td>{{ $in }}</td>
                        <td>{{ $out }}</td>
                        <td><strong>{{ $avail }}</strong></td>
                    </tr>

                @endforeach
                </tbody>

            </table>

        </div>
    </div>

</div>
@endsection
