@extends('layout.app')

@section('content')

<style>
    /* Bigger Windows-style Card */
    .bill-box {
        max-width: 1100px;
        margin: auto;
        padding: 40px;
        border: 1px solid #c6c6c6;
        border-radius: 14px;
        background: #ffffff;
        box-shadow: 0 6px 14px rgba(0,0,0,0.10);
    }

    .title {
        font-size: 32px;
        font-weight: 700;
        color: #202124;
        margin-bottom: 10px;
    }

    .info-box {
        font-size: 18px;
        line-height: 1.6;
    }

    .info-box b {
        width: 180px;
        display: inline-block;
        color: #333;
    }

    /* Table Style */
    table {
        width: 100%;
        margin-top: 20px;
        border-collapse: collapse;
        background: #fbfbfb;
        font-size: 17px;
    }

    table thead {
        background: #e1e9f5;
        font-weight: bold;
        border-bottom: 3px solid #b5c6e0;
    }

    table thead th {
        padding: 14px;
        color: #1d3b6b;
        border-right: 1px solid #c9d5e3;
        font-size: 17px;
    }

    table tbody td {
        padding: 14px;
        font-size: 17px;
        border-bottom: 1px solid #e0e0e0;
        border-right: 1px solid #e0e0e0;
    }

    table tbody tr:hover {
        background: #f1f6ff;
    }

    .total-box {
        text-align: right;
        font-size: 28px;
        margin-top: 20px;
        font-weight: bold;
        color: #111;
    }

    .btn {
        font-size: 16px !important;
        padding: 8px 18px !important;
    }
</style>


<div class="bill-box mt-4">

    {{-- BACK BUTTON --}}
    <div class="float-end">
        @if ($mode === 'purchase')
            <a href="{{ route('user.reports.purchases') }}" class="btn btn-sm btn-secondary">Back to Reports</a>
        @else
            <a href="{{ route('user.reports.sales') }}" class="btn btn-sm btn-secondary">Back to Reports</a>
        @endif
    </div>

    {{-- TITLE --}}
    <div class="title">
        {{ $mode === 'purchase' ? 'Purchase Details' : 'Sales Details' }}
    </div>
    <hr>

    {{-- INFO BOX --}}
    <div class="info-box">
        <b>Date:</b> {{ $bill->date }} <br>
        <b>Line:</b> {{ $bill->line_name }} <br>

        @if($mode === 'purchase')
            <b>Supplier:</b> {{ $bill->supplier_name }} <br>
            <b>Phone:</b> {{ $bill->supplier_contact }} <br>
            <b>Address:</b> {{ $bill->supplier_address }} <br>
        @else
            <b>Customer:</b> {{ $bill->customer_name }} <br>
            <b>Phone:</b> {{ $bill->customer_contact }} <br>
            <b>Address:</b> {{ $bill->customer_address }} <br>
        @endif
    </div>

    <hr>

    <h5>Item Details</h5>

    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Qty</th>
                <th>Rate</th>
                <th>Amount</th>

                @if($mode === 'purchase')
                    <th>Sup Amount</th>
                    <th>Com Amount</th>
                @endif

                <th>Date</th>
            </tr>
        </thead>

        <tbody>
            @foreach($items as $i)
            <tr>
                <td>{{ $i->product_name }}</td>
                <td>{{ $i->quantity }}</td>
                <td>₹ {{ $i->rate }}</td>
                <td>₹ {{ $i->amount }}</td>

                @if($mode === 'purchase')
                    <td>₹ {{ $i->sup_amount }}</td>
                    <td>₹ {{ $i->com_amount }}</td>
                @endif

                <td>{{ $bill->date }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="total-box">
        Total: ₹ {{ $bill->total_amount }}
    </div>

</div>

@endsection


{{-- BACKSPACE GO BACK --}}
<script>
   const backUrl = "{{ $mode === 'purchase'  ? route('user.reports.purchases') : route('user.reports.sales') }}";


    document.addEventListener("keydown", function(e) {

        const active = document.activeElement;
        const typingTags = ["INPUT", "TEXTAREA"];

        if (typingTags.includes(active.tagName)) return;

        if (e.key === "Backspace") {
            e.preventDefault();
            window.location.href = backUrl;
        }
    });
</script>

