@extends('layout.app')

@section('content')

<style>
    .win-card {
        background: #fff;
        padding: 25px;
        border-radius: 10px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        max-width: 1400px;
        margin: auto;
    }

    .customer-header {
        background: #ffe6e6;
        padding: 10px;
        border-left: 5px solid #dc3545;
        margin-top: 20px;
        border-radius: 6px;
    }

    .ledger-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    .ledger-table th,
    .ledger-table td {
        border: 1px solid #dc3545;
        padding: 8px;
        font-size: 15px;
        text-align: center;
    }

    .ledger-table th {
        background: #ffefef;
        font-weight: bold;
        color: #b30000;
        font-size: 16px;
    }

    #searchInput {
        width: 300px;
        padding: 8px 12px;
        border: 2px solid #dc3545;
        border-radius: 6px;
        font-size: 16px;
        margin-bottom: 15px;
    }
</style>

<div class="container mt-4">
    <div class="win-card">

        <h3><i class="fa fa-book text-danger"></i> Sales Ledger</h3>

        <!-- Search -->
        <input type="text" id="searchInput" placeholder="Search customer name / contact...">

        <!-- Global Summary -->
        <div id="summaryBox" class="mt-3"></div>

        <div id="ledgerResults"></div>
    </div>
</div>

<script>
loadLedger();

function loadLedger(search = "") {

    fetch(`{{ route('user.reports.salesledger.search') }}?search=${search}`)
        .then(res => res.json())
        .then(res => {
            const summaryDiv = document.getElementById("summaryBox");
            const div = document.getElementById("ledgerResults");

            // Summary
            summaryDiv.innerHTML = `
                <div class="alert alert-danger">
                    <strong>Total Sales:</strong> ₹${res.summary.total} &nbsp;&nbsp;
                    <strong>Paid:</strong> ₹${res.summary.paid} &nbsp;&nbsp;
                    <strong>Balance:</strong> ₹${res.summary.balance}
                </div>
            `;

            div.innerHTML = "";

            if (!res.data.length) {
                div.innerHTML = `<div class="text-center text-muted p-4">No customer found</div>`;
                return;
            }

            let html = "";

            res.data.forEach(c => {

                html += `
                <div class="customer-header">
                    <h5>${c.customer} <span class="text-secondary">(${c.contact})</span></h5>
                    <p>
                        <strong>Total:</strong> ₹${c.total} &nbsp;&nbsp;
                        <strong>Paid:</strong> ₹${c.paid} &nbsp;&nbsp;
                        <strong>Balance:</strong> ₹${c.balance}
                    </p>
                </div>

                <table class="ledger-table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Bill No</th>
                            <th>Total Amount</th>
                            <th>Paid</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                `;

                c.records.forEach(r => {
                    html += `
                    <tr>
                        <td>${r.date}</td>
                        <td>${r.bill_no}</td>
                        <td>₹ ${r.amount}</td>
                        <td>₹ ${r.paid}</td>
                        <td>₹ ${r.balance}</td>
                    </tr>`;
                });

                html += `</tbody></table>`;
            });

            div.innerHTML = html;
        });
}

document.getElementById("searchInput").addEventListener("keyup", function() {
    loadLedger(this.value);
});
</script>
<script>
document.addEventListener("keydown", function(e) {

    // If user is typing inside input, textarea — ignore backspace
    const active = document.activeElement;
    const typingTags = ["INPUT", "TEXTAREA"];

    if (typingTags.includes(active.tagName)) return;

    // Backspace = go back
    if (e.key === "Backspace") {
        e.preventDefault();
        window.location.href = "{{ route('user.reports.index') }}";
    }
});
</script>
@endsection
