@extends('layout.app')

@section('content')

<style>
    /* Windows Modern Design */
    .win-card {
        background: #ffffff;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        max-width: 1200px;   /* Wider */

        margin: auto;
    }

    .win-input {
        border: 2px solid #d5d5d5;
        border-radius: 6px;
        padding: 10px;
        width: 220px;
        transition: 0.3s;
    }

    .win-input:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 5px #0d6efd;
    }

   table {
    width: 100%;
    margin-top: 15px;
    border-collapse: collapse;
    background: white;
    border: 2px solid #bfc8d6;   /* outer border */
}

thead {
    background: #e5f0ff;
    border-bottom: 2px solid #0d6efd;
}

thead th {
    padding: 12px;
    color: #003eaa;
    font-weight: 600;
    font-size: 15px;
    border-right: 1px solid #bfc8d6;   /* header column border */
}

tbody td {
    padding: 10px;
    font-size: 15px;
    border: 1px solid #d4ddea;   /* row borders */
}

tbody tr:hover {
    background: #e9f2ff;
}

.active-row {
    background: #0d6efd !important;
    color: white !important;
}

   

    .no-data {
        text-align: center;
        padding: 40px;
        color: #777;
    }
</style>

<div class="container mt-4">

    <div class="win-card">

        <h3 class="mb-3">Sales Reports</h3>

        <label><b>Select Date:</b></label><br>
        <input type="date" id="dateInput" class="win-input mb-3">

        <div id="results"></div>

    </div>
</div>

<script>
let activeIndex = -1;
let rows = [];

// Set today's date automatically
document.getElementById("dateInput").valueAsDate = new Date();

// Load on page open also
loadData();

function loadData() {
    let date = document.getElementById("dateInput").value;
    if (!date) return;

fetch(`{{ route('user.reports.sales.searchSales') }}?date=${date}`)

        .then(res => res.json())
        .then(res => {
            const div = document.getElementById("results");
            div.innerHTML = "";

            if (!res.data.length) {
                div.innerHTML = `<div class="no-data">No purchases found</div>`;
                return;
            }

            let html = `
                <table>
                    <thead>
                        <tr>
                            <th>customer</th>
                            <th>Line</th>
                            <th>Amount</th>
                            <th>Time</th>
                        </tr>
                    </thead>
                    <tbody>
            `;

            res.data.forEach((p, i) => {
                html += `
                    <tr class="row-item" data-id="${p.id}">
                        <td>${p.customer_name}</td>
                        <td>${p.line}</td>
                        <td>₹ ${p.amount}</td>
                        <td>${p.time}</td>
                    </tr>
                `;
            });

            html += `</tbody></table>`;
            div.innerHTML = html;

            rows = document.querySelectorAll(".row-item");
            activeIndex = -1;
        });
}

document.getElementById("dateInput").addEventListener("change", loadData);


// ------------------------- KEYBOARD NAVIGATION -------------------------
document.addEventListener("keydown", function(e) {

    if (e.key === "ArrowDown") {
        e.preventDefault();
        if (activeIndex < rows.length - 1) activeIndex++;
        updateActiveRow();
    }

    if (e.key === "ArrowUp") {
        e.preventDefault();
        if (activeIndex > 0) activeIndex--;
        updateActiveRow();
    }

    if (e.key === "Enter" && activeIndex >= 0) {
        let id = rows[activeIndex].getAttribute("data-id");
 window.location.href = `/user/reports/sales/${id}`;

    }

    if (e.key === "Escape") {
        document.getElementById("dateInput").value = "";
        document.getElementById("results").innerHTML = "";
        activeIndex = -1;
    }
});

function updateActiveRow() {
    rows.forEach(r => r.classList.remove("active-row"));
    if (rows[activeIndex]) rows[activeIndex].classList.add("active-row");
}
</script>
<script>
document.addEventListener("keydown", function(e) {

    // If user is typing inside input, textarea — ignore backspace
    const active = document.activeElement;
    const typingTags = ["INPUT", "TEXTAREA"];

    if (typingTags.includes(active.tagName)) return;

    // Backspace = go back
    if (e.key === "Backspace") {
        e.preventDefault();
        window.location.href = "{{ route('user.reports.index') }}";
    }
});
</script>
@endsection
