@extends('layout.app')

@section('content')

<style>
    .win-card {
        background: #ffffff;
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        max-width: 1300px;
        margin: auto;
    }

    .table-responsive {
        width: 100%;
        overflow-x: auto;
        border: 2px solid #0d6efd;
        border-radius: 8px;
    }

    table {
        width: 100%;
        min-width: 900px;
        border-collapse: collapse;
        background: white;
    }

    thead {
        background: #e5f0ff;
        border-bottom: 2px solid #0d6efd;
    }

    thead th {
        padding: 10px;
        font-size: 18px;
        color: #d8134bff;
        font-weight: 800;
        text-align: center;
        border: 1px solid #0d6efd;
        letter-spacing: 0.3px;
    }

    tbody td {
        padding: 9px;
        font-size: 15px;
        border: 1px solid #0d6efd;
    }

    .customer-row {
        background: #eaf2ff;
        font-weight: 700;
        border-top: 2px solid #004fc5 !important;
        border-bottom: 2px solid #004fc5 !important;
    }

    .item-row:hover {
        background: #eef6ff;
    }

    .no-data {
        padding: 35px;
        text-align: center;
        color: #888;
        font-size: 18px;
        font-weight: 600;
    }

    #searchInput {
        width: 260px;
        padding: 9px 12px;
        margin-bottom: 15px;
        border: 2px solid #0d6efd;
        border-radius: 6px;
        font-size: 16px;
    }
</style>

<div class="container mt-4">
    <div class="win-card">
        <h3 class="mb-3">
            <i class="fa fa-calendar-day text-primary"></i> Today Sales Report
        </h3>

        <input type="text" id="searchInput" placeholder="Search customer, product, contact..." />

        <div id="results"></div>
    </div>
</div>



<script>
loadData();

function loadData() {
    fetch(`{{ route('user.reports.dailysales.search') }}`)
        .then(res => res.json())
        .then(res => {

            const div = document.getElementById("results");
            div.innerHTML = "";

            if (!res.data.length) {
                div.innerHTML = `<div class="no-data">No sales made today</div>`;
                return;
            }

            let html = `
                <div class="table-responsive">
                <table id="salesTable">
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th>Contact</th>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Rate</th>
                            <th>Amount</th>
                            <th>Total Bill</th>
                            <th>Paid</th>
                            <th>Time</th>
                        </tr>
                    </thead>
                    <tbody>
            `;

            res.data.forEach((s) => {

                // CUSTOMER ROW
                html += `
                <tr class="customer-row">
                    <td>${s.customer_name}</td>
                    <td>${s.customer_contact}</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>-</td>
                    <td>₹ ${s.total_bill}</td>
                    <td>₹ ${s.paid}</td>
                    <td>${s.time}</td>
                </tr>
                `;

                // PRODUCT ROWS
                s.items.forEach((item) => {
                    html += `
                    <tr class="item-row">
                        <td>-</td>
                        <td>-</td>
                        <td>${item.product_name}</td>
                        <td>${item.quantity}</td>
                        <td>₹ ${item.rate}</td>
                        <td>₹ ${item.amount}</td>
                        <td>-</td>
                        <td>-</td>
                        <td>${item.time}</td>
                    </tr>
                    `;
                });

            });

            html += "</tbody></table></div>";
            div.innerHTML = html;

            enableSearch();
        });
}
</script>



<script>
function enableSearch() {

    const input = document.getElementById("searchInput");

    input.addEventListener("keyup", function () {

        const filter = input.value.toLowerCase();

        fetch(`{{ route('user.reports.dailysales.search') }}?search=${filter}`)
            .then(res => res.json())
            .then(res => {

                const div = document.getElementById("results");
                div.innerHTML = "";

                let html = `
                    <div class="table-responsive">
                    <table id="salesTable">
                        <thead>
                            <tr>
                                <th>Customer</th>
                                <th>Contact</th>
                                <th>Product</th>
                                <th>Qty</th>
                                <th>Rate</th>
                                <th>Amount</th>
                                <th>Total Bill</th>
                                <th>Paid</th>
                                <th>Time</th>
                            </tr>
                        </thead>
                        <tbody>
                `;

                res.data.forEach((s) => {

                    html += `
                    <tr class="customer-row">
                        <td>${s.customer_name}</td>
                        <td>${s.customer_contact}</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>₹ ${s.total_bill}</td>
                        <td>₹ ${s.paid_amount}</td>
                        <td>${s.time}</td>
                    </tr>
                    `;

                    s.items.forEach((item) => {
                        html += `
                        <tr class="item-row">
                            <td>-</td>
                            <td>-</td>
                            <td>${item.product_name}</td>
                            <td>${item.quantity}</td>
                            <td>₹ ${item.rate}</td>
                            <td>₹ ${item.amount}</td>
                            <td>-</td>
                            <td>-</td>
                            <td>${item.time}</td>
                        </tr>
                        `;
                    });

                });

                html += "</tbody></table></div>";
                div.innerHTML = html;

            });
    });
}
</script>
<script>
document.addEventListener("keydown", function(e) {

    // If user is typing inside input, textarea — ignore backspace
    const active = document.activeElement;
    const typingTags = ["INPUT", "TEXTAREA"];

    if (typingTags.includes(active.tagName)) return;

    // Backspace = go back
    if (e.key === "Backspace") {
        e.preventDefault();
        window.location.href = "{{ route('user.reports.index') }}";
    }
});
</script>
@endsection
