@extends('layout.app')

@section('content')
<div class="container mt-4">
    <div class="d-flex justify-content-between mb-3">
        <a href="{{ route('user.purchase.index') }}" class="btn btn-secondary">Back</a>
        <button class="btn btn-primary" onclick="printReceipt()">Print Receipt</button>
    </div>

    <!-- Purchase Details -->
    <div id="purchaseContent">
        <h2 class="mb-4">Purchase Details</h2>

        <div class="card p-4 mb-4 shadow-sm">
            <h5>Purchase Information</h5>
            <p><strong>Purchase ID:</strong> {{ $purchase->id }}</p>
            <p><strong>Supplier Name:</strong> {{ $purchase->supplier_name ?? 'N/A' }}</p>
            <p><strong>Member:</strong> {{ $purchase->member->name ?? 'N/A' }}</p>
            <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($purchase->date)->format('d M, Y') }}</p>
            <p><strong>Description:</strong> {{ $purchase->description }}</p>
            <p><strong>Total Amount:</strong> ${{ number_format($purchase->total_amount, 2) }}</p>
        </div>

        <h5>Items</h5>
        @if($purchase->items->count())
        <table class="table table-bordered table-striped shadow-sm">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Product Name</th>
                    <th>Quantity</th>
                    <th>Unit</th>
                    <th>Rate</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach($purchase->items as $index => $item)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $item->product_name }}</td>
                        <td>{{ $item->quantity }}</td>
                        <td>{{ $item->unit }}</td>
                        <td>${{ number_format($item->rate, 2) }}</td>
                        <td>${{ number_format($item->amount, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @else
            <p class="text-muted">No items found for this purchase.</p>
        @endif
    </div>
</div>

<script>
function printReceipt() {
    // Clone the purchase content for printing
    let receiptContent = document.getElementById('purchaseContent').cloneNode(true);

    let printWindow = window.open('', '', 'height=700,width=600');
    printWindow.document.write('<html><head><title>Purchase Receipt</title>');

    // Include Bootstrap CSS for printing
    printWindow.document.write('<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">');

    // Custom print styles
    printWindow.document.write(`
        <style>
            body { font-family: Arial, sans-serif; padding: 20px; }
            .card { border: none; box-shadow: none; }
            h2 { text-align: center; margin-bottom: 20px; }
            table { width: 100%; border-collapse: collapse; margin-top: 10px; }
            table th, table td { padding: 6px; font-size: 13px; border: 1px solid #000; text-align: center; }
            table th { background-color: #000; color: #fff; }
            .text-left { text-align: left !important; }
            .text-right { text-align: right !important; }
            .no-print { display: none; }
        </style>
    `);

    printWindow.document.write('</head><body>');
    printWindow.document.body.appendChild(receiptContent);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
}
</script>
@endsection
