@extends('layout.app')

@section('content')
<div class="container">

    <div class="d-flex justify-content-between mb-3">
        <h2 class="fw-bold">Purchase List</h2>
        <a href="{{ route('user.purchase.create') }}" class="btn btn-primary">Add Purchase</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>Date</th>
                <th>Supplier</th>
                <th>Line</th>
                <th>Description</th>
                <th>Total Amount</th>
                <th width="220">Actions</th>
            </tr>
        </thead>

        <tbody>
            @forelse($purchases as $purchase)
            <tr>
                <td>{{ $purchase->date }}</td>
                <td>{{ $purchase->supplier_name }}</td>
                <td>{{ $purchase->line_name }}</td>
                <td>{{ $purchase->description }}</td>
                <td>₹ {{ number_format($purchase->total_amount, 2) }}</td>

                <td>
                    <a href="{{ route('user.purchase.show', $purchase->id) }}" 
                       class="btn btn-info btn-sm">View</a>

                    <a href="{{ route('user.purchase.edit', $purchase->id) }}" 
                       class="btn btn-warning btn-sm">Edit</a>

                    <form action="{{ route('user.purchase.destroy', $purchase->id) }}" 
                          method="POST" 
                          style="display:inline;">
                        @csrf
                        @method('DELETE')

                        <button class="btn btn-danger btn-sm"
                                onclick="return confirm('Are you sure you want to delete this purchase?')">
                            Delete
                        </button>
                    </form>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="6" class="text-center text-muted">No purchases found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>

</div>
@endsection
