@extends('layout.app')

@section('content')
<div class="container">
    <h2>Edit Purchase</h2>

    <form action="{{ route('user.purchase.update', $purchase->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label>Product Name</label>
            <input 
                type="text" 
                name="product" 
                value="{{ $purchase->product }}" 
                class="form-control" 
                required>
        </div>

        <div class="mb-3">
            <label>Quantity</label>
            <input 
                type="number" 
                name="qty" 
                value="{{ $purchase->qty }}" 
                class="form-control" 
                required>
        </div>

        <div class="mb-3">
            <label>Amount</label>
            <input 
                type="number" 
                name="amount" 
                value="{{ $purchase->amount }}" 
                class="form-control" 
                required>
        </div>

        <button class="btn btn-warning">Update</button>
        <a href="{{ route('user.purchase.index') }}" class="btn btn-secondary">Back</a>
    </form>
</div>
@endsection
