@extends('layout.app')

@section('content')

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">Products</h4>
        <a href="{{ route('user.products.create') }}" class="btn btn-primary btn-sm">
            <i class="fa fa-plus me-1"></i> Add Product
        </a>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th width="50">#</th>
                            <th>Product Name</th>
                            <th>Unit</th>
                            <th>Stock</th>
                            <th>Description</th>
                            <th>price</th>
                
                            <th width="140">Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($products as $index => $item)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item->product_name }}</td>
                                <td>{{ $item->unit }}</td>
                                <td>{{ $item->stock }}</td>
                                <td>{{ $item->description }}</td>
                                <td>{{ $item->price  }}</td>
                          
                                <td>
                                    <a href="{{ route('user.products.edit', $item->id) }}"
                                       class="btn btn-sm btn-warning">
                                        <i class="fa fa-edit"></i>
                                    </a>

                                    <form action="{{ route('user.products.destroy', $item->id) }}"
                                          method="POST"
                                          class="d-inline"
                                          onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>

                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-3">
                                    No products added yet.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>

                </table>
            </div>

        </div>
    </div>

</div>

@endsection
