@extends('layout.app')

@section('content')

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">Edit Product</h4>

        <a href="{{ route('user.products.index') }}" class="btn btn-secondary btn-sm">
            <i class="fa fa-arrow-left me-1"></i> Back
        </a>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            <form action="{{ route('user.products.update', $product->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="row g-3">

                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Product Name *</label>
                        <input type="text" name="product_name" class="form-control"
                               value="{{ $product->product_name }}" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Unit *</label>
                        <input type="text" name="unit" class="form-control"
                               value="{{ $product->unit }}" required>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Min Stock</label>
                        <input type="number" name="min_stock" class="form-control"
                               value="{{ $product->min_stock }}">
                    </div>

                </div>

                <div class="mt-4 d-flex gap-2">
                    <button type="submit" class="btn btn-primary px-4">
                        <i class="fa fa-save me-1"></i> Update
                    </button>

                    <a href="{{ route('user.products.index') }}" class="btn btn-light border px-4">
                        Cancel
                    </a>
                </div>

            </form>

        </div>
    </div>

</div>

@endsection
