@extends('layout.app')

@section('content')
<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="fw-bold">Edit Member</h3>
        <a href="{{ route('user.members.index') }}" class="btn btn-secondary">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">

            <form action="{{ route('user.members.update', $member->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="row">

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Member Name *</label>
                        <input type="text" name="name" value="{{ $member->name }}"
                               class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Select Line *</label>
                        <select name="line_id" class="form-select" required>
                            @foreach($lines as $line)
                                <option value="{{ $line->id }}"
                                        {{ $member->line_id == $line->id ? 'selected' : '' }}>
                                    {{ $line->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Phone *</label>
                        <input type="text" name="phone" value="{{ $member->phone }}"
                               class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Address *</label>
                        <input type="text" name="address" value="{{ $member->address }}"
                               class="form-control" required>
                    </div>

                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Update
                </button>

            </form>

        </div>
    </div>

</div>
@endsection
