@extends('layout.app')

@section('content')
<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="fw-bold">Lines</h3>
        <a href="{{ route('user.lines.create') }}" class="btn btn-primary">
            <i class="fa fa-plus"></i> Add New Line
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">

            <table class="table table-bordered table-striped table-responsive">
                <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Line Name</th>
                    <th>Actions</th>
                </tr>
                </thead>

                <tbody>
                @forelse($lines as $line)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $line->line_name }}</td>
                        <td>
                            <a href="{{ route('user.lines.edit', $line->line_id) }}" class="btn btn-sm btn-warning">
                                <i class="fa fa-edit"></i>
                            </a>

                            <form action="{{ route('user.lines.destroy', $line->line_id) }}"
                                  method="POST"
                                  class="d-inline-block"
                                  onsubmit="return confirm('Delete this line?');">
                                @csrf
                                @method('DELETE')

                                <button class="btn btn-sm btn-danger">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </form>

                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">No lines added yet.</td>
                    </tr>
                @endforelse
                </tbody>

            </table>

        </div>
    </div>

</div>
@endsection
