@extends('layout.app')

@section('content')
<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="fw-bold">Edit Line</h3>
        <a href="{{ route('user.lines.index') }}" class="btn btn-secondary">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">

            <form action="{{ route('user.lines.update', $line->line_id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label class="form-label">Line Name <span class="text-danger">*</span></label>
                    <input type="text" name="line_name"
                           class="form-control"
                           value="{{ $line->name }}"
                           required>
                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Update
                </button>

            </form>

        </div>
    </div>

</div>
@endsection
