<!-- resources/views/user/expenses/create.blade.php -->
<!-- Windows-style expense form with keyboard + mouse support, SweetAlert, clean logic -->

@extends('layout.app')
@section('content')

<style>
    body {
        background: #eef1f5;
        font-family: "Segoe UI", sans-serif;
    }

    .win-card {
        width: 950px;
        margin: 30px auto;
        background: #fff;
        padding: 25px;
        border-radius: 14px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.10);
    }

    .cat-container {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 10px;
    }

    .cat-item {
        padding: 12px;
        border-radius: 10px;
        border: 2px solid #ccc;
        cursor: pointer;
        text-align: center;
        font-size: 18px;
        background: #f9f9f9;
        transition: 0.2s;
    }
    .cat-item:hover { background: #e9f3ff; }
    .cat-item.active {
        border-color: #0078d4;
        background: #d9ebff;
    }

    .form-input {
        width: 100%;
        padding: 12px;
        margin-top: 12px;
        font-size: 18px;
        border-radius: 10px;
        border: 1px solid #bbb;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 25px;
    }

    th, td {
        padding: 12px;
        border-bottom: 1px solid #ddd;
        font-size: 16px;
    }
</style>

<div class="win-card">
    <h2 style="margin-bottom: 15px">Add Daily Expense</h2>

    <!-- CATEGORY LIST -->
    <div class="cat-container" id="categoryList">
        @foreach($categories as $c)
            <div class="cat-item" data-id="{{ $c->id }}">{{ $c->name }}</div>
        @endforeach
    </div>

    <input type="text" id="customCategory" class="form-input" placeholder="Or type category manually">

    <input type="text" id="descInput" class="form-input" style="display:none;" placeholder="Description">
    <input type="date" id="dateInput" class="form-input" style="display:none;" value="{{ date('Y-m-d') }}">
    <input type="number" id="amountInput" class="form-input" style="display:none;" placeholder="Amount">

    <table id="previewTable" style="display:none;">
        <thead>
            <tr>
                <th>Category</th>
                <th>Description</th>
                <th>Date</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
$(document).ready(function () {
    let expenses = [];
    let currentStep = 0;
    let expense = { category: '', description: '', date: '', amount: '' };

    // --- Category click ---
    $(document).on("click", ".category-option", function () {
        expense.category = $(this).data("value");
        $("#categoryInput").val(expense.category);
        nextStep();
    });

    // --- ENTER key logic ---
    $(document).on("keydown", function (e) {
        if (e.key === "Enter") {
            e.preventDefault();
            if (currentStep === 0) {
                expense.category = $("#categoryInput").val();
                if (expense.category.trim() === '') return;
                nextStep();
            } else if (currentStep === 1) {
                expense.description = $("#descriptionInput").val();
                nextStep();
            } else if (currentStep === 2) {
                expense.date = $("#dateInput").val();
                nextStep();
            } else if (currentStep === 3) {
                expense.amount = $("#amountInput").val();
                showConfirm();
            }
        }
    });

    function nextStep() {
        currentStep++;
        $(".step-card").hide();
        $("#step-" + currentStep).show().find("input").focus();
    }

    function resetForm() {
        currentStep = 0;
        expense = { category: '', description: '', date: '', amount: '' };
        $("input").val('');
        $(".step-card").hide();
        $("#step-0").show().find("input").focus();
    }

    function showConfirm() {
        Swal.fire({
            title: "Add another expense?",
            showDenyButton: true,
            confirmButtonText: "Yes",
            denyButtonText: "Save All"
        }).then((result) => {
            if (result.isConfirmed) {
                expenses.push({ ...expense });
                updateTable();
                resetForm();
            } else if (result.isDenied) {
                expenses.push({ ...expense });
                saveAll();
            }
        });
    }

    function updateTable() {
        let html = '';
        expenses.forEach((e, i) => {
            html += `<tr><td>${i+1}</td><td>${e.category}</td><td>${e.description}</td><td>${e.date}</td><td>${e.amount}</td></tr>`;
        });
        $("#expenseTableBody").html(html);
    }

    function saveAll() {
        $.ajax({
            url: "{{ route('user.expenses.store') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                expenses: expenses
            },
            success: function () {
                Swal.fire("Saved!", "Expenses stored successfully", "success");
                expenses = [];
                updateTable();
                resetForm();
            }
        });
    }
});
</script>

@endsection
