@extends('layout.app')

@section('content')
<div class="container mt-4">
    <div class="win-card p-4" style="max-width:700px;margin:auto;">
        <h3>Edit Expense</h3>

        <form method="POST" action="{{ route('user.expenses.update', $expense->id) }}">
            @csrf
            @method('PUT')

            <div class="mb-3">
                <label class="form-label">Category</label>
                <select name="category_id" class="form-control">
                    <option value="">-- Select --</option>
                    @foreach($categories as $c)
                        <option value="{{ $c->id }}" @selected(($expense->category_id ?? old('category_id')) == $c->id)>{{ $c->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3">
                <label>Title</label>
                <input name="title" value="{{ old('title', $expense->title) }}" class="form-control">
            </div>

            <div class="mb-3">
                <label>Amount</label>
                <input name="amount" value="{{ old('amount', $expense->amount) }}" required class="form-control" type="number" step="0.01">
            </div>

            <div class="mb-3">
                <label>Date</label>
                <input name="date" type="date" value="{{ old('date', $expense->date->toDateString()) }}" required class="form-control">
            </div>

            <div class="mb-3">
                <label>Description</label>
                <textarea name="description" class="form-control">{{ old('description', $expense->description) }}</textarea>
            </div>

            <div class="d-flex gap-2">
                <button class="btn btn-primary">Update</button>
                <a href="{{ route('user.expenses.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
