@extends('layout.app')

@section('content')

<style>
.card {
    padding: -30px;
    border-radius: 10px;
    transition: 0.3s ease;
    cursor: pointer;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
}

.card i {
    font-size: 40px;
    margin-bottom: 10px;
}



.admin-wrapper {
    font-family: "Poppins", sans-serif;
    background: linear-gradient(135deg, #00d2ff, #3a47d5);
    min-height: calc(100vh - 70px);
    padding: 35px;
    margin: 0;
}

.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    margin-bottom: 25px;
}

.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 28px;
  margin-left: 15px;
}

.switch input { opacity: 0; width: 0; height: 0; }

.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
}

.slider:before {
  position: absolute;
  content: "";
  height: 22px;
  width: 22px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  transition: 0.4s;
  border-radius: 50%;
}

input:checked + .slider { background-color: #ff5252; }
input:checked + .slider:before { transform: translateX(32px); }

.card-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(230px, 1fr));
    gap: 22px;
}

.card {
    background: rgba(255,255,255,0.18);
    backdrop-filter: blur(14px);
    padding: 25px;
    border-radius: 18px;
    color: #fff;
    border: 1px solid rgba(255,255,255,0.25);
    box-shadow: 0 8px 30px rgba(0,0,0,0.25);
    transition: 0.3s;
    cursor: pointer;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 35px rgba(0,0,0,0.35);
}

.logout-btn {
    background: #ff5252;
    padding: 8px 16px;
    border: none;
    border-radius: 10px;
    color: #fff;
    cursor: pointer;
    font-weight: 600;
    margin-left: 10px;
}

.card i {
    font-size: 38px;
    margin-bottom: 12px;
}
</style>

<div class="admin-wrapper">

    <!-- TOP BAR -->
    <div class="topbar">
        <h2 style="margin:0;">{{ t('Admin Dashboard') }}</h2>

        <div style="display:flex; align-items:center;">{{ __('messages.language') }}
            <label class="switch">
                <input type="checkbox" id="langToggle" {{ App::getLocale() == 'ta' ? 'checked' : '' }}>
                <span class="slider"></span>
                {{ App::getLocale() == 'ta' ? 'English' : 'தமிழ்' }}
            </label>
        </div>
    </div>

    <!-- DASHBOARD CARDS -->
    <div class="card-container">


        <!-- 👉 NEW UPCOMING MODULES CARD -->
        <a href="{{ route('user.manage.managedashboard') }}" style="text-decoration:none;">
            <div class="card">
                <i class="fa fa-layer-group"></i>
                <h3>Upcoming Modules</h3>
                <p>New features coming soon</p>
            </div>
        </a>

 
<div class="row">
    <!-- Purchase Payment -->
    <div class="col-md-6">
        <a href="{{ route('user.purchase.payment') }}" style="text-decoration:none;">
            <div class="card text-center">
                <i class="fa fa-money-bill-wave"></i>
                <h3>Purchase Payment</h3>
                <p>Pay supplier outstanding balance</p>
            </div>
        </a>
    </div>

    <!-- Sales Payment -->
    <div class="col-md-6">
        <a href="{{ route('user.sales.payment') }}" style="text-decoration:none;">
            <div class="card text-center">
                <i class="fa fa-hand-holding-usd"></i>
                <h3>Sales Payment</h3>
                <p>Receive customer pending amount</p>
            </div>
        </a>
    </div>
</div>
   </div>
</div>

<script>
document.getElementById('langToggle').addEventListener('change', function() {
    let locale = this.checked ? 'ta' : 'en';
    window.location.href = '/lang/' + locale;
});
</script>

@endsection
