@extends('layout.app')

@section('content')
<div class="container mt-4">
    <div class="win-card p-4" style="max-width:700px;margin:auto;">
        <h3>Add Expense</h3>

        <form method="POST" action="{{ route('user.expenses.store') }}">
            @csrf

            <div class="mb-3">
                <label class="form-label">Category</label>
                <select name="category_id" class="form-control">
                    <option value="">-- Select --</option>
                    @foreach($categories as $c)
                        <option value="{{ $c->id }}" @selected(old('category_id') == $c->id)>{{ $c->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3">
                <label>Title</label>
                <input name="title" value="{{ old('title') }}" class="form-control">
            </div>

            <div class="mb-3">
                <label>Amount</label>
                <input name="amount" value="{{ old('amount') }}" required class="form-control" type="number" step="0.01">
            </div>

            <div class="mb-3">
                <label>Date</label>
                <input name="date" type="date" value="{{ old('date', now()->toDateString()) }}" required class="form-control">
            </div>

            <div class="mb-3">
                <label>Description</label>
                <textarea name="description" class="form-control">{{ old('description') }}</textarea>
            </div>

            <div class="d-flex gap-2">
                <button class="btn btn-primary">Save</button>
                <a href="{{ route('user.expenses.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
