<!-- Sidebar -->
<aside id="sidebar"
       class="sidebar bg-white border-end shadow-sm position-fixed top-0 start-0 h-100"
       style="width:260px; transform: translateX(-100%); transition: 0.3s ease; z-index:1050;">

    <!-- Logo -->
    <div class="p-3 border-bottom d-flex justify-content-between align-items-center">
        <h4 class="m-0 fw-bold">{{ t('Mandi Menu') }}</h4>

        <!-- Close (mobile) -->
        <button class="btn btn-sm btn-light d-lg-none" onclick="toggleSidebar()">
            <i class="fa fa-times"></i>
        </button>
    </div>

    <!-- Menu -->
    <div class="p-3 overflow-auto" style="height: calc(100% - 60px);">
        @php
            $role_id = session('role_id');
        @endphp

        @if($role_id == 1)
            {{-- Admin menus --}}
         <a href="{{ route('admin.dashboard') }}" class="sidebar-link d-flex align-items-center">
    <i class="fa fa-tachometer-alt me-3"></i>
    <span>{{ __('Dashboard') }}</span>
</a>

      <a href="{{ route('admin.create') }}" class="sidebar-link">
    <i class="fa fa-user-plus me-3"></i>
    <span>{{ t('Add User') }}</span>
</a>


            <a href="{{ url('/admin/users') }}" class="sidebar-link">
                <i class="fa fa-users me-3"></i>
                <span>{{ t('Manage Users') }}</span>
            </a>

            <a href="{{ url('/admin/menus') }}" class="sidebar-link">
                <i class="fa fa-list me-3"></i>
                <span>{{ t('Menu Creation') }}</span>
            </a>

            <a href="{{ url('/admin/settings') }}" class="sidebar-link">
                <i class="fa fa-cogs me-3"></i>
                <span>{{ t('Settings') }}</span>
            </a>

        @elseif($role_id == 2)
            {{-- User menus --}}
            <a href="{{ route('user.dashboard') }}" class="sidebar-link">
                <i class="fa fa-tachometer-alt me-3"></i>
                <span>{{ t('Dashboard') }}</span>
            </a>

           <a href="{{ route('user.lines.create') }}" class="sidebar-link">
    <i class="fa fa-road me-3"></i>
    <span>Lines</span>
</a>

<a href="{{ route('user.members.create') }}" class="sidebar-link">
    <i class="fa fa-users me-3"></i>
    <span>Members</span>
</a>

<a href="{{ route('user.products.create') }}" class="sidebar-link">
    <i class="fa fa-box me-3"></i>
    <span>Products</span>
</a>

<a href="{{ route('user.purchase.create') }}" class="sidebar-link">
    <i class="fa fa-shopping-cart me-3"></i>
    <span>Purchase</span>
</a>

<a href="{{ route('user.sales.create') }}" class="sidebar-link">
    <i class="fa fa-chart-line me-3"></i>
    <span>Sales</span>
</a>

<a href="{{ route('user.reports.index') }}" class="sidebar-link">
    <i class="fa fa-file-alt me-3"></i>
    <span>Reports</span>
</a>


        @else
            <p class="text-muted">{{ t('Please login to see menu.') }}</p>
        @endif
    </div>
</aside>

<!-- Overlay -->
<div id="sidebarOverlay"
     class="position-fixed w-100 h-100 top-0 start-0 bg-dark bg-opacity-50 d-none"
     style="z-index:1040;"
     onclick="toggleSidebar()">
</div>

<style>
    /* Sidebar links */
    .sidebar-link {
        display: flex;
        align-items: center;
        padding: 10px 15px;
        margin-top: 10px;
        margin-bottom: 8px;
        border-radius: 6px;
        color: #444;
        font-weight: 500;
        text-decoration: none; /* Remove underline */
        transition: all 0.2s ease-in-out;
    }

    /* Hover effect */
    .sidebar-link:hover {
        background-color: #f1f1f1;
        color: #1a73e8;
        padding-left: 20px; /* subtle slide effect */
    }

    /* Icon styling */
    .sidebar-link i {
        font-size: 16px;
        width: 20px; /* fixed width for alignment */
        text-align: center;
    }

    /* Optional: scroll bar styling */
    .sidebar::-webkit-scrollbar {
        width: 6px;
    }

    .sidebar::-webkit-scrollbar-thumb {
        background-color: rgba(0,0,0,0.1);
        border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-track {
        background: transparent;
    }
</style>

<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');

        if (sidebar.style.transform === 'translateX(0px)') {
            sidebar.style.transform = 'translateX(-100%)';
            overlay.classList.add('d-none');
        } else {
            sidebar.style.transform = 'translateX(0px)';
            overlay.classList.remove('d-none');
        }
    }
</script>
