<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ session('shopname', '') }}</title>
    
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">




    <!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- Select2 JS -->

    <style>
        :root { --sidebar-width: 260px; }
        body.light { background: #ececec; color: #111; }
        body.dark { background: #1f1f1f; color: #eee; }

        /* Fixed header */
        #header-wrapper {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            z-index: 9999;
        }

        /* Sidebar */
        #sidebar {
            position: fixed;
            top: 70px; /* header height */
            left: 0;
            width: var(--sidebar-width);
            height: calc(100% - 70px);
            overflow-y: auto;
            transition: transform .3s ease;
            background: #fff;
            z-index: 1050;
            transform: translateX(-100%);
        }

        /* Content wrapper scrollable */
        #page-content-wrapper {
            margin-top: 70px; /* header height */
            margin-left: 0;
            transition: margin-left .3s ease;
            height: calc(100vh - 70px);
            overflow-y: auto;
        }

        /* Desktop: push content right when sidebar open */
        @media (min-width: 992px) {
            body.sidebar-open #page-content-wrapper {
                margin-left: var(--sidebar-width);
            }
        }

        /* Mobile overlay */
        #sidebarOverlay {
            display: none;
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100% - 70px);
            background: rgba(0,0,0,0.5);
            z-index: 1040;
        }
        body.sidebar-open #sidebarOverlay {
            display: block !important;
        }
    </style>
    @livewireStyles

</head>

<body class="light d-flex flex-column min-vh-100">

    {{-- Sidebar --}}
    @include('layout.sidebar')

    {{-- Overlay for mobile --}}
    <div id="sidebarOverlay" onclick="toggleSidebar()"></div>

    {{-- Page Content Wrapper --}}
    <div id="page-content-wrapper" class="flex-fill d-flex flex-column">

        {{-- Header --}}
        <div id="header-wrapper">@include('layout.header')</div>

        {{-- Main Content --}}
        <div class="container-fluid py-3 flex-fill">
            @yield('content')
        </div>

        {{-- Footer --}}
        @include('layout.footer')

    </div>
    @livewireScripts

</body>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById("sidebar");
            const overlay = document.getElementById("sidebarOverlay");

            const isOpen = sidebar.style.transform === "translateX(0%)";

            if (isOpen) {
                sidebar.style.transform = "translateX(-100%)";
                overlay.classList.remove('show');
                document.body.classList.remove("sidebar-open");
            } else {
                sidebar.style.transform = "translateX(0%)";
                overlay.classList.add('show');
                document.body.classList.add("sidebar-open");
            }
        }

        // Theme save
        document.addEventListener("DOMContentLoaded", function () {
            const savedTheme = localStorage.getItem("theme") || "light";
            document.body.classList.add(savedTheme);
        });
    </script>

</body>
</html>
