<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">

    <title class="fs-3">Mandi</title>

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: "Poppins", sans-serif;
            background: linear-gradient(135deg, #00d2ff, #3a47d5);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
        }

        .circle {
            position: absolute;
            border-radius: 50%;
            opacity: 0.35;
            animation: float 7s infinite ease-in-out alternate;
        }
        .circle1 {
            width: 160px;
            height: 160px;
            background: #ffffff;
            top: 15%;
            left: 10%;
        }
        .circle2 {
            width: 220px;
            height: 220px;
            background: #ffffff;
            bottom: 10%;
            right: 15%;
        }

        @keyframes float {
            from { transform: translateY(0px); }
            to { transform: translateY(-25px); }
        }

        .login-container {
            width: 100%;
            max-width: 380px;
            padding: 35px 32px;
            border-radius: 18px;
            backdrop-filter: blur(14px);
            background: rgba(255, 255, 255, 0.18);
            box-shadow: 0 10px 45px rgba(0,0,0,0.25);
            text-align: center;
            border: 1px solid rgba(255,255,255,0.25);
        }

        .shop-logo {
            width: 70px;
            margin-bottom: 10px;
            filter: drop-shadow(0 3px 6px rgba(0,0,0,0.2));
        }

        h2 {
            margin: 0;
            margin-bottom: 10px;
            font-size: 24px;
            color: #fff;
            font-weight: 600;
        }

        .subtitle {
            color: #e0e0e0;
            font-size: 13px;
            margin-bottom: 20px;
        }

        label {
            float: left;
            margin: 5px 0 3px 2px;
            color: #fff;
            font-size: 13px;
        }

        input {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: none;
            outline: none;
            font-size: 14px;
            margin-bottom: 12px;
            background: rgba(255,255,255,0.85);
            transition: 0.3s;
        }

        input:focus {
            background: #fff;
            box-shadow: 0 0 6px rgba(0, 210, 255, 0.8);
        }

        button {
            width: 50%;
            padding: 11px;
            background: #00d2ff;
            border: none;
            border-radius: 8px;
            color: #fff;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 10px;
            transition: 0.3s ease;
        }

        button:hover {
            background: #189dbbff;
            transform: scale(1.03);
        }

        .error-message {
            color: #ffb3b3;
            margin-bottom: 10px;
            font-size: 13px;
        }

    </style>
</head>

<body>

    <div class="circle circle1"></div>
    <div class="circle circle2"></div>

    <div class="login-container">

        <img src="https://cdn-icons-png.flaticon.com/512/3081/3081648.png" class="shop-logo">

        <h2>Mandi Login</h2>
        <p class="subtitle">Manage all your shops in one place</p>
{{-- For error message from return back()->with('error') --}}
@if(session('error'))
    <p class="error-message">{{ session('error') }}</p>
@endif

{{-- For logout success message --}}
@if(session('status'))
    <p class="error-message" style="color: #c7ffb7;">{{ session('status') }}</p>
@endif

{{-- For validation errors --}}
@if($errors->any())
    <p class="error-message">{{ $errors->first() }}</p>
@endif

        @if(session('error'))
            <p class="error-message">{{ session('error') }}</p>
        @endif

        <form method="POST" action="{{ route('login.submit') }}">
            
            @csrf

            <label>Username</label>
            <input type="text" name="username" placeholder="Enter username" required>

            <label>Password</label>
            <input type="password" name="password" placeholder="Enter password" required>

            <button type="submit">Login</button>
        </form>

    </div>

</body>
</html>
