@extends('layout.app')

@section('content')

<style>
.admin-wrapper {
    font-family: "Poppins", sans-serif;
    background: linear-gradient(135deg, #00d2ff, #3a47d5);
    min-height: calc(100vh - 70px);
    padding: 35px;
    margin: 0;
}

.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: #fff;
    margin-bottom: 25px;
}

.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 28px;
  margin-left: 15px;
}

.switch input { opacity: 0; width: 0; height: 0; }

.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
}

.slider:before {
  position: absolute;
  content: "";
  height: 22px;
  width: 22px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  transition: 0.4s;
  border-radius: 50%;
}

input:checked + .slider {
  background-color: #ff5252;
}

input:checked + .slider:before {
  transform: translateX(32px);
}

.card-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(230px, 1fr));
    gap: 22px;
}

.card {
    background: rgba(255,255,255,0.18);
    backdrop-filter: blur(14px);
    padding: 25px;
    border-radius: 18px;
    color: #fff;
    border: 1px solid rgba(255,255,255,0.25);
    box-shadow: 0 8px 30px rgba(0,0,0,0.25);
    transition: 0.3s;
}

.logout-btn {
    background: #ff5252;
    padding: 8px 16px;
    border: none;
    border-radius: 10px;
    color: #fff;
    cursor: pointer;
    font-weight: 600;
    margin-left: 10px;
}
</style>

<div class="admin-wrapper">

    <!-- TOP BAR -->
    <div class="topbar">
        <h2 style="margin:0;">{{ t('Admin Dashboard') }}</h2>
          <!-- <h5>{{ __('messages.system_settings') }}</h5> -->

        <div style="display:flex; align-items:center;">{{ __('messages.language') }}
            <!-- Language Toggle -->
            <label class="switch">
                <input type="checkbox" id="langToggle" {{ session('locale') == 'ta' ? 'checked' : '' }} {{ App::getLocale() == 'ta' ? 'checked' : '' }}>
                <span class="slider"></span>
                {{ App::getLocale() == 'ta' ? 'English' : 'தமிழ்' }}
            </label>

            <!-- Logout -->
            <!-- <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                @csrf
                <button class="logout-bnt">{{ t('Logout') }}</button>
            </form> -->
        </div>
    </div>

    <!-- DASHBOARD CARDS -->
    <div class="card-container">
        <div class="card">
            <h3>{{ t('Total Shops') }}</h3>
            <p>12 {{ t('Shops') }}</p>
        </div>

        <div class="card">
            <h3>{{ t('Total Users') }}</h3>
            <p>42 {{ t('Users') }}</p>
        </div>

        <div class="card">
            <h3>{{ t('Today Sales') }}</h3>
            <p>₹18,450</p>
        </div>

        <div class="card">
            <h3>{{ t('Low Stock') }}</h3>
            <p>6 {{ t('Items') }}</p>
        </div>
    </div>

</div>  

<script>
document.getElementById('langToggle').addEventListener('change', function() {
    let locale = this.checked ? 'ta' : 'en';
    window.location.href = '/lang/' + locale;
});
</script>
<script>
     $('#langToggle').change(function () {
        let locale = $(this).is(':checked') ? 'ta' : 'en';
        window.location.href = "{{ url('lang') }}/" + locale;
    });
</script>


@endsection
