@extends('layout.app')

@section('content')

<style>
/* =========================
   Page Layout
========================= */
.container-custom {
    display: flex;
    gap: 25px;
    margin-top: 25px;
    flex-wrap: wrap; /* responsive wrap */
    transition: all 0.3s ease;
}

/* Left Section – Form */
.glass-card {
    flex: 1 1 100%; /* full width on mobile */
    max-width: 400px; /* normal width */
    position: relative;
    background: rgba(84, 201, 230, 0.25);
    backdrop-filter: blur(12px);
    padding: 25px;
    border-radius: 20px;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    min-width: 300px;
    transition: all 0.3s ease;
}

.glass-card.expanded {
    max-width: 100%; /* full width when expanded */
}

.glass-title {
    text-align: center;
    font-size: 26px;
    font-weight: 700;
    color: #fff;
    margin-bottom: 20px;
}

/* Expand Icon */
#expandFormIcon {
    position: absolute;
    top: 15px;
    right: 15px;
    font-size: 20px;
    color: #fff;
    cursor: pointer;
    transition: transform 0.3s ease;
}

#expandFormIcon.expanded {
    transform: rotate(180deg);
}

/* Form Inputs */
.form-label {
    font-weight: 600;
    color: #fff;
}

.form-control, .form-select {
    border-radius: 12px;
    padding: 12px;
    font-size: 15px;
    border: none;
}

.btn-submit {
    background: #fff;
    color: #333;
    border-radius: 14px;
    padding: 12px;
    font-size: 16px;
    font-weight: 700;
    width: 100%;
    margin-top: 15px;
}

/* Table */
.table-card {
    flex: 1 1 100%; /* full width on mobile */
    max-width: 1000px;
    background: #fff;
    padding: 20px;
    border-radius: 15px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
    overflow-x: auto;
    transition: all 0.3s ease;
}

.table-card.shift-down {
    order: 2; /* move table below form when form expanded */
    max-width: 100%; /* full width under form */
}

.table-card h3 {
    font-weight: 700;
    margin-bottom: 15px;
    text-align: center;
}

table {
    width: 100%;
    min-width: 600px;
}

/* Buttons */
.btn-edit {
    background: #00bcd4;
    color: #fff;
    border-radius: 6px;
    padding: 5px 12px;
    font-size: 13px;
    text-decoration: none;
}

.btn-delete {
    background: #e91e63;
    color: #fff;
    border-radius: 6px;
    padding: 5px 12px;
    font-size: 13px;
    text-decoration: none;
}

.btn-edit i, .btn-delete i {
    margin: 0;
}

/* Validation error messages */
.error-messages {
    background: #ffdddd;
    border: 1px solid #ff5c5c;
    padding: 10px;
    border-radius: 6px;
    margin-bottom: 15px;
    color: #d8000c;
}

/* Toggle Switch for Tamil/English */
.switch {
  position: relative;
  display: inline-block;
  width: 50px;
  height: 28px;
  margin-bottom: 20px;
}

.switch input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider {
  position: absolute;
  cursor: pointer;
  inset: 0;
  background: #ccc;
  border-radius: 28px;
  transition: 0.4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 22px;
  width: 22px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  border-radius: 50%;
  transition: 0.4s;
}

input:checked + .slider {
  background: #4E9CAF;
}

input:checked + .slider:before {
  transform: translateX(22px);
}

.toggle-label {
    display: inline-block;
    margin-left: 10px;
    font-weight: 600;
    color: #fff;
    vertical-align: middle;
}

/* Responsive adjustments */
@media (max-width: 991px) {
    .container-custom {
        flex-direction: column;
        gap: 20px;
    }
}
</style>

<div class="container-custom">

    <!-- LEFT SIDE - Add/Edit User Form -->
    <div class="glass-card" id="formCard">
        <div class="glass-title">
            {{ isset($editUser) ? '✏️ Edit User' : '✨ Add New User' }}
        </div>

        <!-- Expand/Collapse Icon -->
        <i class="fas fa-expand-alt" id="expandFormIcon" title="Expand/Collapse Form"></i>

        @if($errors->any())
            <div class="error-messages">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form 
            action="{{ isset($editUser) ? route('admin.update', $editUser->id) : route('admin.store') }}" 
            method="POST"
        >
            <div style="text-align:center; margin-bottom:15px;">
                <label class="switch">
                    <input type="checkbox" id="toggleTamil">
                    <span class="slider"></span>
                </label>
                <span id="toggleLabel" class="toggle-label">English</span>
            </div>

            @csrf
            @if(isset($editUser))
                @method('POST')
            @endif

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Username *</label>
                    <input type="text" name="username" class="form-control"  id="username"
                           value="{{ old('username', $editUser->username ?? '') }}" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">{{ isset($editUser) ? 'Password (leave blank if unchanged)' : 'Password *' }}</label>
                    <input type="password" name="password" class="form-control" {{ isset($editUser) ? '' : 'required' }}>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Shop Name *</label>
                    <input type="text" name="shop_name" class="form-control" 
                           value="{{ old('shop_name', $editUser->shop_name ?? '') }}" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Owner Name *</label>
                    <input type="text" name="owner_name" class="form-control" 
                           value="{{ old('owner_name', $editUser->owner_name ?? '') }}" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Role *</label>
                    <select name="role_id" class="form-select" required>
                        <option value="">Select Role</option>
                        <option value="1" {{ old('role_id', $editUser->role_id ?? '')==1 ? 'selected' : '' }}>Admin</option>
                        <option value="2" {{ old('role_id', $editUser->role_id ?? '')==2 ? 'selected' : '' }}>User</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Phone</label>
                    <input type="text" name="phone" class="form-control" 
                           value="{{ old('phone', $editUser->phone ?? '') }}">
                </div>

                <div class="col-12">
                    <label class="form-label">Status *</label>
                    <select name="status" class="form-select" required>
                        <option value="1" {{ old('status', $editUser->status ?? 1)==1 ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ old('status', $editUser->status ?? 1)==0 ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
            </div>

            <button type="submit" class="btn-submit">
                {{ isset($editUser) ? 'Update User' : 'Save User' }}
            </button>
        </form>
    </div>

    <!-- RIGHT SIDE - Users Table -->
    <div class="table-card" id="userTableCard">
        <h3>📋 Manage Users</h3>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Username</th>
                    <th>Password</th>
                    <th>Shop</th>
                    <th>Owner</th>
                    <th>Phone</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th width="120">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($users as $u)
                    <tr>
                        <td>{{ $u->username }}</td>
                        <td>{{ $u->password }}</td>
                        <td>{{ $u->shop_name }}</td>
                        <td>{{ $u->owner_name }}</td>
                        <td>{{ $u->phone }}</td>
                        <td>
                            @if($u->role_id == 1) Admin
                            @elseif($u->role_id == 2) User
                            @else Viewer @endif
                        </td>
                        <td>{{ $u->status == 1 ? 'Active' : 'Inactive' }}</td>
                        <td>
                            <a href="{{ route('admin.edit', $u->id) }}" class="btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="{{ route('admin.destroy', $u->id) }}" class="btn-delete" onclick="return confirm('Delete this user?')">
                                <i class="fas fa-trash-alt"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

</div>


<script>




    // Toggle Tamil/English
    let currentLanguage = 'en';
    const toggleInput = document.getElementById('toggleTamil');
    const toggleLabel = document.getElementById('toggleLabel');

    toggleInput.addEventListener('change', function() {
        if(this.checked) {
            currentLanguage = 'ta';
            toggleLabel.textContent = 'Tamil';
        } else {
            currentLanguage = 'en';
            toggleLabel.textContent = 'English';
        }
    });

   const tamilMap = {
    // Vowels
    'a': 'அ', 'aa': 'ஆ', 'i': 'இ', 'ii': 'ஈ', 'u': 'உ', 'uu': 'ஊ',
    'e': 'எ', 'ee': 'ஏ', 'ai': 'ஐ', 'o': 'ஒ', 'oo': 'ஓ', 'au': 'ஔ',

    // Grantha consonants (basic)
    'k': 'க', 'ng': 'ங',
    'c': 'ச', 'nj': 'ஞ',
    't': 'ட', 'n': 'ண',
    'th': 'த', 'ndh': 'ந',
    'p': 'ப', 'm': 'ம',
    'y': 'ய', 'r': 'ர', 'l': 'ல',
    'v': 'வ', 'zh': 'ழ', 'L': 'ள', 'R': 'ற', 'nn': 'ன',
    
    // Consonant + vowel combinations
    'ka': 'க', 'kaa': 'கா', 'ki': 'கி', 'kii': 'கீ', 'ku': 'கு', 'kuu': 'கூ', 'ke': 'கெ', 'kee': 'கே', 'kai': 'கை', 'ko': 'கொ', 'koo': 'கோ', 'kau': 'கௌ',
    'nga': 'ங', 'ngaa': 'ஙா', 'ngi': 'ஙி', 'ngii': 'ஙீ', 'ngu': 'ஙு', 'nguu': 'ஙூ', 'nge': 'ஙெ', 'ngee': 'ஙே', 'ngai': 'ஙை', 'ngo': 'ஙொ', 'ngoo': 'ஙோ', 'ngau': 'ஙௌ',

    'ca': 'ச', 'caa': 'சா', 'ci': 'சி', 'cii': 'சீ', 'cu': 'சு', 'cuu': 'சூ', 'ce': 'செ', 'cee': 'சே', 'cai': 'சை', 'co': 'சொ', 'coo': 'சோ', 'cau': 'சௌ',
    'nja': 'ஞ', 'njaa': 'ஞா', 'nji': 'ஞி', 'njii': 'ஞீ', 'nju': 'ஞு', 'njuu': 'ஞூ', 'nje': 'ஞெ', 'njee': 'ஞே', 'njai': 'ஞை', 'njo': 'ஞொ', 'njoo': 'ஞோ', 'njau': 'ஞௌ',

    'ta': 'ட', 'taa': 'டா', 'ti': 'டி', 'tii': 'டீ', 'tu': 'டு', 'tuu': 'டூ', 'te': 'டெ', 'tee': 'டே', 'tai': 'டை', 'to': 'டொ', 'too': 'டோ', 'tau': 'டௌ',
    'na': 'ண', 'naa': 'ணா', 'ni': 'ணி', 'nii': 'ணீ', 'nu': 'ணு', 'nuu': 'ணூ', 'ne': 'ணெ', 'nee': 'ணே', 'nai': 'ணை', 'no': 'ணொ', 'noo': 'ணோ', 'nau': 'ணௌ',

    'tha': 'த', 'thaa': 'தா', 'thi': 'தி', 'thii': 'தீ', 'thu': 'து', 'thuu': 'தூ', 'the': 'தெ', 'thee': 'தே', 'thai': 'தை', 'tho': 'தொ', 'thoo': 'தோ', 'thau': 'தௌ',
    'na2': 'ந', 'naa2': 'நா', 'ni2': 'நி', 'nii2': 'நீ', 'nu2': 'நு', 'nuu2': 'நூ', 'ne2': 'நெ', 'nee2': 'நே', 'nai2': 'நை', 'no2': 'நொ', 'noo2': 'நோ', 'nau2': 'நௌ',

    'pa': 'ப', 'paa': 'பா', 'pi': 'பி', 'pii': 'பீ', 'pu': 'பு', 'puu': 'பூ', 'pe': 'பெ', 'pee': 'பே', 'pai': 'பை', 'po': 'பொ', 'poo': 'போ', 'pau': 'பௌ',
    'ma': 'ம', 'maa': 'மா', 'mi': 'மி', 'mii': 'மீ', 'mu': 'மு', 'muu': 'மூ', 'me': 'மெ', 'mee': 'மே', 'mai': 'மை', 'mo': 'மொ', 'moo': 'மோ', 'mau': 'மௌ',

    'ya': 'ய', 'yaa': 'யா', 'yi': 'யி', 'yii': 'யீ', 'yu': 'யு', 'yuu': 'யூ', 'ye': 'யெ', 'yee': 'யே', 'yai': 'யை', 'yo': 'யொ', 'yoo': 'யோ', 'yau': 'யௌ',

    'ra': 'ர', 'raa': 'ரா', 'ri': 'ரி', 'rii': 'ரீ', 'ru': 'ரு', 'ruu': 'ரூ', 're': 'ரெ', 'ree': 'ரே', 'rai': 'ரை', 'ro': 'ரொ', 'roo': 'ரோ', 'rau': 'ரௌ',

    'la': 'ல', 'laa': 'லா', 'li': 'லி', 'lii': 'லீ', 'lu': 'லு', 'luu': 'லூ', 'le': 'லெ', 'lee': 'லே', 'lai': 'லை', 'lo': 'லொ', 'loo': 'லோ', 'lau': 'லௌ',

    'va': 'வ', 'vaa': 'வா', 'vi': 'வி', 'vii': 'வீ', 'vu': 'வு', 'vuu': 'வூ', 've': 'வெ', 'vee': 'வே', 'vai': 'வை', 'vo': 'வொ', 'voo': 'வோ', 'vau': 'வௌ',

    'zha': 'ழ', 'zhaa': 'ழா', 'zhi': 'ழி', 'zhii': 'ழீ', 'zhu': 'ழு', 'zhuu': 'ழூ', 'zhe': 'ழெ', 'zhee': 'ழே', 'zhai': 'ழை', 'zho': 'ழொ', 'zhoo': 'ழோ', 'zhau': 'ழௌ',

    'La': 'ள', 'Laa': 'ளா', 'Li': 'ளி', 'Lii': 'ளீ', 'Lu': 'ளு', 'Luu': 'ளூ', 'Le': 'ளெ', 'Lee': 'ளே', 'Lai': 'ளை', 'Lo': 'ளொ', 'Loo': 'ளோ', 'Lau': 'ளௌ',

    'Ra': 'ற', 'Raa': 'றா', 'Ri': 'றி', 'Rii': 'றீ', 'Ru': 'று', 'Ruu': 'றூ', 'Re': 'றெ', 'Ree': 'றே', 'Rai': 'றை', 'Ro': 'றொ', 'Roo': 'றோ', 'Rau': 'றௌ',

    'naN': 'ன', 'naaN': 'னா', 'niN': 'னி', 'niiN': 'னீ', 'nuN': 'னு', 'nuuN': 'னூ', 'neN': 'னெ', 'neeN': 'னே', 'naiN': 'னை', 'noN': 'னொ', 'nooN': 'னோ', 'nauN': 'னௌ',

    // Special characters
    'm1': 'ஃ'
};

    function transliterateEnglishToTamil(str) {
        for (let key in tamilMap) {
            const regex = new RegExp(key, 'g');
            str = str.replace(regex, tamilMap[key]);
        }
        return str;
    }

    const inputs = document.querySelectorAll('.glass-card input[type="text"]');
    inputs.forEach(input => {
        input.addEventListener('input', function() {
            if(currentLanguage === 'ta') {
                this.value = transliterateEnglishToTamil(this.value);
            }
        });
    });

    // Expand/Collapse Form
    const expandIcon = document.getElementById('expandFormIcon');
    const formCard = document.getElementById('formCard');
    const tableCard = document.getElementById('userTableCard');

    expandIcon.addEventListener('click', function() {
        formCard.classList.toggle('expanded');
        tableCard.classList.toggle('shift-down');
        expandIcon.classList.toggle('expanded');
    });
</script>



@endsection
