@extends('layout.app')

@section('content')
<div class="container py-4">
    <div class="card shadow-lg p-4">
        <div class="d-flex align-items-center mb-3">
            <i class="bi bi-gear fs-1 me-3 text-primary"></i>
            <h3 class="mb-0">{{ t('Settings') }}</h3>
        </div>
        <hr>

        <!-- System Settings -->
        <h5>{{ t('System Settings') }}</h5>
        <div class="row mb-3">

            <!-- Theme Toggle -->
            <div class="col-md-6">
                <p><strong>{{ t('Theme') }}:</strong></p>
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="themeToggle">
                    <label class="form-check-label" for="themeToggle" id="themeLabel">{{ t('Light') }}</label>
                </div>
            </div>

            <!-- Language Toggle Switch -->
            <div class="col-md-6">
                <p><strong>{{ t('Language') }}:</strong></p>
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="languageToggle" {{ session('locale') == 'ta' ? 'checked' : '' }}>
                    <label class="form-check-label" for="languageToggle" id="languageLabel">
                        {{ session('locale') == 'ta' ? 'English' : 'தமிழ்' }}
                    </label>
                </div>
            </div>

        </div>

        <!-- Update Password -->
        <h5>{{ t('Update Password') }}</h5>
        <form action="{{ route('account.password.update') }}" method="POST">
            @csrf
            <div class="mb-3">
                <label class="form-label">{{ t('Current Password') }}</label>
                <input type="password" name="current_password" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">{{ t('New Password') }}</label>
                <input type="password" name="new_password" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">{{ t('Confirm Password') }}</label>
                <input type="password" name="new_password_confirmation" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-success">{{ t('Update Password') }}</button>
        </form>

        <div id="alert-msg" class="alert mt-3 d-none"></div>
    </div>
</div>

<!-- JS for Theme & Language -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {

    // -------------------
    // Theme Toggle Logic
    // -------------------
    const backendTheme = "{{ $settings['theme'] ?? 'light' }}";
    let savedTheme = localStorage.getItem('theme') || backendTheme;

    applyTheme(savedTheme);
    $('#themeToggle').prop('checked', savedTheme === 'dark');
    $('#themeLabel').text(savedTheme === 'dark' ? t('Dark') : t('Light'));

    $('#themeToggle').change(function () {
        let theme = $(this).is(':checked') ? 'dark' : 'light';
        $('#themeLabel').text(theme === 'dark' ? t('Dark') : t('Light'));
        applyTheme(theme);
        localStorage.setItem('theme', theme);
    });

    function applyTheme(theme) {
        $('body').removeClass('light dark').addClass(theme);
    }

    // -------------------
    // Language Toggle Switch
    // -------------------
    $('#languageToggle').change(function () {
        let locale = $(this).is(':checked') ? 'ta' : 'en';
        window.location.href = "/lang/" + locale;
    });

});
</script>
@endsection
