<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('purchase_payments', function (Blueprint $table) {
            $table->id();
                    $table->unsignedBigInteger('user_id'); // each shop belongs to a user/admin
                    
            $table->date('payment_date');
            $table->unsignedBigInteger('line_id');
            $table->string('line_name');
            $table->string('supplier_name');
            $table->unsignedBigInteger('supplier_id');
            $table->string('description')->nullable();
            $table->decimal('paid_amount', 12, 2);

            $table->timestamps();
                           $table->softDeletes(); // <-- added deleted_at column
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_payments');
    }
};
