<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('shop_profiles', function (Blueprint $table) {
        $table->id();

        $table->unsignedBigInteger('user_id'); // each shop belongs to a user/admin

        // Basic Shop Information
        $table->string('shop_name');
        $table->string('shop_logo')->nullable();
        $table->string('owner_name')->nullable();
        $table->string('phone');
        $table->string('alternate_phone')->nullable();
        $table->string('email')->nullable();
        $table->string('address')->nullable();
        $table->string('city')->nullable();
        $table->string('state')->nullable();
        $table->string('pincode')->nullable();


           $table->string('shop_name_ta')->nullable();
        $table->string('owner_name_ta')->nullable();
        $table->string('address_ta')->nullable();
        $table->string('city_ta')->nullable();
        $table->string('state_ta')->nullable();
        $table->timestamps();

        // foreign key
        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    });
}

};
