<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->decimal('amount', 12, 2)->default(0.00);
            $table->date('date')->nullable();
            $table->timestamps();

            $table->index(['user_id']);
            $table->index(['date']);
            $table->foreign('category_id')->references('id')->on('expense_categories')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('expenses');
    }
};
