<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up()
    {
        Schema::create('expense_categories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); // user-specific if set
            $table->string('name');
            $table->string('slug')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        // seed common categories (global - user_id = null)
        DB::table('expense_categories')->insert([
            ['user_id' => null, 'name' => 'Lorry', 'slug'=>'lorry', 'created_at'=>now(),'updated_at'=>now()],
            ['user_id' => null, 'name' => 'Labour', 'slug'=>'labour', 'created_at'=>now(),'updated_at'=>now()],
            ['user_id' => null, 'name' => 'Diesel', 'slug'=>'diesel', 'created_at'=>now(),'updated_at'=>now()],
            ['user_id' => null, 'name' => 'Office', 'slug'=>'office', 'created_at'=>now(),'updated_at'=>now()],
            ['user_id' => null, 'name' => 'Misc', 'slug'=>'misc', 'created_at'=>now(),'updated_at'=>now()],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('expense_categories');
    }
};
