<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
{
    Schema::create('sales_items', function (Blueprint $table) {
        $table->id();

        // USER
        $table->foreignId('user_id')
              ->constrained('users')
              ->onDelete('cascade');

        // PRODUCT
        $table->foreignId('product_id')
              ->constrained('products')
              ->onDelete('cascade');

        // ITEMS_ID → linked to purchases table
        $table->unsignedBigInteger('items_id');
        $table->foreign('items_id')
              ->references('id')
              ->on('sales')
              ->onDelete('cascade');

        // LINE
        $table->unsignedBigInteger('line_id');
        // (Only add FK if line table exists)
        // $table->foreign('line_id')->references('id')->on('lines')->onDelete('cascade');

        $table->string('line_name', 100);

        // PRODUCT NAME (cannot be unique)
        $table->string('product_name', 255)->nullable();

        
        $table->decimal('quantity', 10, 2);
        $table->decimal('rate', 10, 2);
        $table->decimal('amount', 10, 2);

        $table->dateTime('sales_date');
        $table->timestamps();
               $table->softDeletes(); // <-- added deleted_at column
    });
}

public function down()
{
    Schema::dropIfExists('sales_items');
}

};
