<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
    {
        Schema::create('sales', function (Blueprint $table) {

            // Primary Key
            $table->id(); // purchase_id auto

            // Your supplier ID (not primary key)
            $table->integer('customer_id')->nullable();

            // User link
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // Member / Supplier reference
            $table->foreignId('member_id')->nullable()->constrained('members')->onDelete('cascade');

            // Supplier details
            $table->string('customer_name', 255);
            $table->string('customer_contact', 100)->nullable();
            $table->string('customer_address', 500)->nullable();

            // Line details
            $table->integer('line_id')->nullable();
            $table->string('line_name')->nullable();

            // Items ID
            $table->integer('items_id')->nullable();

            // Other fields
     
            $table->date('date');
            $table->decimal('paid_amount', 10, 2)->default(0);
            $table->decimal('total_amount', 10, 2)->default(0);

            $table->timestamps();
                $table->softDeletes(); // <-- added deleted_at column
        });
    }

    public function down()
    {
        Schema::dropIfExists('sales');
    }

};
