<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // link member to user

            $table->string('name');
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('type')->comment('Customer, Supplier');

            $table->timestamps();
            $table->softDeletes(); // <-- added deleted_at column
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('members');
    }
};
