<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
      Schema::create('lines', function (Blueprint $table) {
    $table->id('line_id');
    $table->foreignId('user_id')->constrained()->onDelete('cascade');

    $table->string('line_name');
    $table->string('type'); // Customer / Supplier
    $table->softDeletes();
    $table->timestamps();

    // Unique per user + type + name
    $table->unique(['user_id', 'type', 'line_name']);
});

    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('lines');
    }
};
