<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

            $table->string('username')->unique();
            $table->string('password');  
            $table->string('shop_name');
            $table->string('owner_name');

            // ✔ Correct: Role as role_id + FK
            $table->unsignedBigInteger('role_id');

            $table->string('phone')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();

            // ✔ Foreign key constraint
            $table->foreign('role_id')
                  ->references('id')
                  ->on('roles')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
};
