<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class SalesItem extends Model
{
        use SoftDeletes;

    protected $fillable = [
        'product_id',
        'customer_id',
        'product_name',
        'quantity',
        'rate',
        'amount',
        'user_id',
        'items_id',
        'line_id',
        'line_name',
        'sales_date',
    ];

    public function sale()
    {
        return $this->belongsTo(Sales::class, 'items_id', 'id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

}
