<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Sales extends Model
{
        use SoftDeletes;

    protected $fillable = [
        'user_id',
        'customer_id',
        'member_id',
        'customer_name',
        'customer_contact',
        'customer_address',
        'line_id',
        'line_name',
        'items_id',
        'date',
        'total_amount',
        'paid_amount',
    ];

    public function items()
    {
        return $this->hasMany(SalesItem::class, 'items_id', 'id');
    }

    public function member()
    {
        return $this->belongsTo(Member::class);
    }

}
