<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseItem extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'purchase_id',
        'supplier_id',
        'product_id',
        'product_name',
        'quantity',
        'rate',
        'amount',
        'sup_amount',
        'comm',
        'com_amount',
        'user_id',
        'items_id',
        'line_id',
        'line_name',
        'purchase_date',
        'lastCoAmount',
    ];

    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
