<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model
{
    use SoftDeletes;

    protected $table = 'members';
    protected $primaryKey = 'id'; // default OK

    protected $fillable = [
        'name',
        'phone',
        'address',
        'type',
        'user_id',

    ];

    protected $dates = ['deleted_at']; // not required but good

    // Relationship with Line
    public function line()
    {
        return $this->belongsTo(Line::class, 'line_id', 'line_id');
    }

    // Relationship with Purchase
    public function purchases()
    {
        return $this->hasMany(Purchase::class, 'member_id', 'id');
    }

    // Relationship with Sale
    public function sales()
    {
        return $this->hasMany(Sales::class, 'member_id', 'id');
    }
}
