<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Line extends Model
{
    use SoftDeletes;

    protected $table = 'lines';
    protected $primaryKey = 'line_id';   // IMPORTANT - you asked to keep this
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'line_name',
        'type',      // 'Customer' or 'Supplier'
        'user_id',
    ];

    // SoftDeletes uses this column
    protected $dates = ['deleted_at'];

    public function members()
    {
        return $this->hasMany(Member::class);
    }
    public function getRouteKeyName()
{
    return 'line_id';
}

}
