<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ExpenseRequest extends FormRequest
{
    public function authorize()
    {
        return true; // your middleware handles access
    }

    public function rules()
    {
        return [
            'category_id' => 'nullable|exists:expense_categories,id',
            'title'       => 'nullable|string|max:255',
            'amount'      => 'required|numeric|min:0',
            'description' => 'nullable|string|max:2000',
            'date'        => 'required|date',
        ];
    }
}
