<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RedirectIfAuthenticated
{
    public function handle(Request $request, Closure $next, $guard = null)
    {
        if (session()->has('user_id')) {
            if (session('role_id') == 1) {
                return redirect()->route('admin.dashboard');
            } elseif(session('role_id') == 2) {
                return redirect()->route('user.dashboard');
            }
        }

        return $next($request);
    }
}
    