<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User\Shop_Profiles;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Helpers\FastTranslate;
class shop_profile extends Controller
{
    // Show profile page (view: resources/views/account/profile.blade.php)
    public function index()
    {
       

        return view('account.profile', compact('profile'));
    }
// INSERT shop profile (new card form)
// public function saveShopProfile(Request $request)
// {
//     // Validate inputs
//     $validated = $request->validate([
//         'shop_name'       => 'required|string|max:255',
//         'owner_name'      => 'nullable|string|max:255',
//         'phone'           => 'required|string|max:20',
//         'alternate_phone' => 'nullable|string|max:20',
//         'email'           => 'nullable|email|max:255',
//         'address'         => 'nullable|string|max:500',
//         'city'            => 'nullable|string|max:255',
//         'state'           => 'nullable|string|max:255',
//         'pincode'         => 'nullable|string|max:10',
//         'shop_logo'       => 'nullable|image|max:2048',
//     ]);

//     // Check if already exists → update instead of creating duplicate
//     $profile = ShopProfile::where('user_id', Auth::id())->first();

//     if (!$profile) {
//         $profile = new ShopProfile();
//         $profile->user_id = Auth::id();
//     }

//     // Upload logo
//     if ($request->hasFile('shop_logo')) {
//         $validated['shop_logo'] = $request->file('shop_logo')->store('shop_logos', 'public');
//     }

//     // Save values
//     $profile->shop_name       = $validated['shop_name'];
//     $profile->owner_name      = $validated['owner_name'] ?? null;
//     $profile->phone           = $validated['phone'];
//     $profile->alternate_phone = $validated['alternate_phone'] ?? null;
//     $profile->email           = $validated['email'] ?? null;
//     $profile->address         = $validated['address'] ?? null;
//     $profile->city            = $validated['city'] ?? null;
//     $profile->state           = $validated['state'] ?? null;
//     $profile->pincode         = $validated['pincode'] ?? null;
//     $profile->shop_logo       = $validated['shop_logo'] ?? $profile->shop_logo;

//     $profile->save();

//     return back()->with('success', 'Shop Details Saved Successfully!');
// }

public function saveShopProfile(Request $request)
{
    // Validate
    $validated = $request->validate([
        'shop_name'       => 'required|string|max:255',
        'owner_name'      => 'nullable|string|max:255',
        'phone'           => 'required|string|max:20',
        'alternate_phone' => 'nullable|string|max:20',
        'email'           => 'nullable|email|max:255',
        'address'         => 'nullable|string|max:500',
        'city'            => 'nullable|string|max:255',
        'state'           => 'nullable|string|max:255',
        'pincode'         => 'nullable|string|max:10',
        'shop_logo'       => 'nullable|image|max:2048',
    ]);

    $userId = session('user_id');

    // fetch or create
    $profile = Shop_Profiles::firstOrNew(['user_id' => $userId]);

    // ✔ FIXED: Delete old logo if new one uploaded
    if ($request->hasFile('shop_logo')) {

        if ($profile->shop_logo && Storage::disk('public')->exists($profile->shop_logo)) {
            Storage::disk('public')->delete($profile->shop_logo);
        }

        $path = $request->file('shop_logo')->store('shop_logos', 'public');
        $profile->shop_logo = $path;

        // ✔ Update session logo
        session(['shop_logo' => $path]);
    }

    // English values
    $profile->shop_name       = $validated['shop_name'];
    $profile->owner_name      = $validated['owner_name'] ?? null;
    $profile->phone           = $validated['phone'];
    $profile->alternate_phone = $validated['alternate_phone'] ?? null;
    $profile->email           = $validated['email'] ?? null;
    $profile->address         = $validated['address'] ?? null;
    $profile->city            = $validated['city'] ?? null;
    $profile->state           = $validated['state'] ?? null;
    $profile->pincode         = $validated['pincode'] ?? null;

    // Tamil translate
    $profile->shop_name_ta  = FastTranslate::toTamil($validated['shop_name']);
    $profile->owner_name_ta = FastTranslate::toTamil($validated['owner_name'] ?? "");
    $profile->address_ta    = FastTranslate::toTamil($validated['address'] ?? "");
    $profile->city_ta       = FastTranslate::toTamil($validated['city'] ?? "");
    $profile->state_ta      = FastTranslate::toTamil($validated['state'] ?? "");

    $profile->save();

    return back()->with('success', 'Shop Details Saved Successfully!');
}

    // Update profile
 public function update(Request $request)
{
    $userId = session('user_id');

    $profile = Shop_Profiles::firstOrNew(['user_id' => $userId]);

    // ================= BASIC FIELDS =================
    $profile->shop_name  = $request->shop_name;
    $profile->owner_name = $request->owner_name;
    $profile->phone      = $request->phone;
    $profile->email      = $request->email;
    $profile->address    = $request->address;
    $profile->city       = $request->city;
    $profile->state      = $request->state;
    $profile->pincode    = $request->pincode;

    // ================= TAMIL TRANSLATION (ADDED) =================
    $profile->shop_name_ta  = FastTranslate::toTamil($request->shop_name ?? '');
    $profile->owner_name_ta = FastTranslate::toTamil($request->owner_name ?? '');
    $profile->address_ta    = FastTranslate::toTamil($request->address ?? '');
    $profile->city_ta       = FastTranslate::toTamil($request->city ?? '');
    $profile->state_ta      = FastTranslate::toTamil($request->state ?? '');

    // ================= LOGO UPDATE =================
    if ($request->hasFile('shop_logo')) {

        // delete old logo
        if ($profile->shop_logo && Storage::disk('public')->exists('shop_logos/'.$profile->shop_logo)) {
            Storage::disk('public')->delete('shop_logos/'.$profile->shop_logo);
        }

        // upload new logo
        $file = $request->file('shop_logo');
        $fileName = uniqid() . '.' . $file->extension();

        Storage::disk('public')->putFileAs('shop_logos', $file, $fileName);

        $profile->shop_logo = $fileName;

        // optional: update session logo
        session(['shop_logo' => 'shop_logos/'.$fileName]);
    }

    $profile->save();

    return response()->json(['success' => true]);
}



public function fetch()
{
    $userId = session('user_id');

    $profile = Shop_Profiles::where('user_id', $userId)->first();

    if (!$profile) {
        return response()->json(null);
    }

    return response()->json([
        'shop_logo'      => $profile->shop_logo,
        'shop_name'      => $profile->shop_name,
        'owner_name'     => $profile->owner_name,
        'shop_address'   => $profile->shop_address,
        'shop_city'      => $profile->shop_city,
        'shop_state'     => $profile->shop_state,
        'shop_pincode'   => $profile->shop_pincode,
        'shop_phone'     => $profile->shop_phone,
        'shop_email'     => $profile->shop_email,
    ]);
}

}
