<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SettingsController extends Controller
{
  public function toggleTheme(Request $request)
    {
        $theme = $request->theme === 'dark' ? 'dark' : 'light';

        // Save to session
        session(['theme' => $theme]);

        return response()->json([
            'success' => true,
            'theme'   => $theme,
        ]);
    }
}
