<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\User\Shop_Profiles;

class LoginController extends Controller
{
    public function showLoginForm(Request $request)
    {
        if ($request->session()->has('user_id')) {

            $roleId = $request->session()->get('role_id');

            if ($roleId == 1) {
                return redirect()->route('admin.dashboard');
            } elseif ($roleId == 2) {
                return redirect()->route('user.dashboard');
            }
        }

        return view('auth.login');
    }

   public function login(Request $request)
{
    $request->validate([
        'username' => 'required|string',
        'password' => 'required|string',
    ]);

    $user = User::where('username', $request->username)
                ->where('password', $request->password)
                ->first();

    if (!$user) {
        return back()->with('error', 'Invalid username or password.');
    }

    // Fetch shop profile
    $profile = Shop_Profiles::where('user_id', $user->id)->first();



    // Store in session
   // Store in session
$request->session()->put([
    'user_id'    => $user->id,
    'username'   => $user->username,
    'shopname'   => $user->shop_name,
    'owner_name' => $user->owner_name,
    'role_id'    => $user->role_id,

    // ✔ Store only filename
    'shop_logo'  => $profile?->shop_logo ?? null,
]);


    // Redirect based on role
    return $user->role_id == 1 
            ? redirect()->route('admin.dashboard')
            : redirect()->route('user.dashboard');
}


    public function logout(Request $request)
    {
        $request->session()->flush();
        return redirect()->route('login')->with('status', 'Logged out');
    }
}
